/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementExtension;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.entities.ElementId;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.query.FacetQuery;
import org.nuiton.wikitty.query.FacetSortType;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.search.operators.AssociatedRestriction;
import org.nuiton.wikitty.search.operators.Between;
import org.nuiton.wikitty.search.operators.BinaryOperator;
import org.nuiton.wikitty.search.operators.Contains;
import org.nuiton.wikitty.search.operators.False;
import org.nuiton.wikitty.search.operators.In;
import org.nuiton.wikitty.search.operators.Restriction;
import org.nuiton.wikitty.search.operators.RestrictionName;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.WikittySearchEngineHelper;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittySearchEngineInMemory
implements WikittySearchEngine {
    private static Log log = LogFactory.getLog(WikittySearchEngineInMemory.class);
    protected WikittyStorageInMemory wikittyStorage;
    public static Comparator<Object> genericComparator = new Comparator<Object>(){

        @Override
        public int compare(Object v1, Object v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            if (v1 == v2 || v1.equals(v2)) {
                return 0;
            }
            if (v1 instanceof Collection) {
                v1 = CollectionUtils.get((Object)v1, (int)0);
            }
            if (v2 instanceof Collection) {
                v2 = CollectionUtils.get((Object)v2, (int)0);
            }
            if (!(v1 instanceof Comparable)) {
                return 0;
            }
            Comparable c1 = (Comparable)v1;
            if (!(v2 instanceof Comparable)) {
                return 0;
            }
            Comparable c2 = (Comparable)v2;
            int result = c1.compareTo(c2);
            return result;
        }
    };

    public WikittySearchEngineInMemory(WikittyStorageInMemory wikittyStorage) {
        this.wikittyStorage = wikittyStorage;
    }

    @Override
    public void clear(WikittyTransaction transaction) {
    }

    @Override
    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
    }

    @Override
    public void delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
    }

    private static boolean checkRestriction(WikittySearchEngine searchEngine, WikittyTransaction transaction, Condition condition, Wikitty w) {
        WikittyQueryVisitorCheckCondition v = new WikittyQueryVisitorCheckCondition(searchEngine, transaction, w);
        condition.accept(v);
        boolean result = v.getResult();
        return result;
    }

    @Override
    public WikittyQueryResult<String> findAllByQuery(WikittyTransaction transaction, WikittyQuery query) {
        WikittyQueryResult<String> result;
        if (query.getCondition() instanceof Select) {
            result = WikittySearchEngineHelper.findAllByQueryWithSelect(this, transaction, query);
        } else {
            int offset = query.getOffset();
            int limit = query.getLimit();
            LinkedList<String> ids = new LinkedList<String>();
            FacetPredicate facets = new FacetPredicate(this, transaction, query);
            ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(this.wikittyStorage.getWikitties().values());
            if (!query.getSortAscending().isEmpty() || !query.getSortDescending().isEmpty()) {
                Collections.sort(wikitties, new WikittyComparator(query.getSortAscending(), query.getSortDescending()));
            }
            int totalResult = 0;
            for (Wikitty w : wikitties) {
                String id = w.getWikittyId();
                Condition c = query.getCondition();
                if (w.isDeleted() || !WikittySearchEngineInMemory.checkRestriction(this, transaction, c, w)) continue;
                if (++totalResult > offset && ids.size() < limit) {
                    ids.add(id);
                }
                facets.add(w);
            }
            result = new WikittyQueryResult(query.getName(), offset, totalResult, query.getCondition().toString(), facets.getFacets(), ids, 0L, 0L);
        }
        return result;
    }

    @Override
    public WikittyQueryResultTreeNode<String> findAllChildrenCount(WikittyTransaction transaction, String wikittyId, int depth, boolean count, WikittyQuery filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        int firstIndex = criteria.getFirstIndex();
        int endIndex = criteria.getEndIndex();
        LinkedList<String> ids = new LinkedList<String>();
        int currentIndex = 0;
        for (Map.Entry<String, Wikitty> entry : this.wikittyStorage.getWikitties().entrySet()) {
            Wikitty w = entry.getValue();
            String id = entry.getKey();
            Restriction dto = criteria.getRestriction();
            if (w.isDeleted() || !this.checkRestriction(transaction, dto, w)) continue;
            if (++currentIndex > firstIndex) {
                ids.add(id);
            }
            if (endIndex < 0 || currentIndex < endIndex) continue;
            break;
        }
        return new PagedResult<String>(criteria.getName(), firstIndex, ids.size(), criteria.getRestriction().toString(), null, ids);
    }

    @Override
    public TreeNodeResult<String> findAllChildrenCount(WikittyTransaction transaction, String wikittyId, int depth, boolean count, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean checkRestriction(WikittyTransaction transaction, Restriction restriction, Wikitty w) {
        if (restriction instanceof BinaryOperator) {
            BinaryOperator binOp = (BinaryOperator)restriction;
            String fqfieldName = binOp.getElement().getName();
            if (org.nuiton.wikitty.search.operators.Element.ELT_EXTENSION.equals(fqfieldName)) {
                boolean checked = false;
                switch (restriction.getName()) {
                    case NOT_EQUALS: {
                        checked = !w.getExtensionNames().contains(binOp.getValue());
                        break;
                    }
                    case EQUALS: {
                        checked = w.getExtensionNames().contains(binOp.getValue());
                    }
                }
                return checked;
            }
            if (org.nuiton.wikitty.search.operators.Element.ELT_ID.equals(fqfieldName)) {
                boolean checked = false;
                switch (restriction.getName()) {
                    case NOT_EQUALS: {
                        checked = !w.getWikittyId().equals(binOp.getValue());
                        break;
                    }
                    case EQUALS: {
                        checked = w.getWikittyId().equals(binOp.getValue());
                    }
                }
                return checked;
            }
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return RestrictionName.NOT_EQUALS == restriction.getName();
            }
            Object o = w.getFqField(fqfieldName);
            FieldType t = w.getFieldType(fqfieldName);
            Object value = binOp.getValue();
            if (!(value instanceof Collection) && t.isCollection()) {
                value = Collections.singleton(value);
            }
            value = t.getValidValue(value);
            boolean checked = false;
            switch (restriction.getName()) {
                case EQUALS: {
                    if (value instanceof String && o instanceof String) {
                        String pattern = (String)value;
                        pattern = pattern.replace("*", "\\p{ASCII}*");
                        pattern = pattern.replace("?", "\\p{ASCII}");
                        Pattern p = Pattern.compile(pattern);
                        Matcher m = p.matcher((String)o);
                        checked = m.matches();
                        break;
                    }
                    checked = value.equals(o);
                    break;
                }
                case LESS: {
                    checked = ((Comparable)o).compareTo(value) < 0;
                    break;
                }
                case LESS_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) <= 0;
                    break;
                }
                case GREATER: {
                    checked = ((Comparable)o).compareTo(value) > 0;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) >= 0;
                    break;
                }
                case NOT_EQUALS: {
                    checked = !value.equals(o);
                    break;
                }
                case ENDS_WITH: {
                    if (t.getType() != WikittyTypes.STRING) {
                        throw new WikittyException("Can't search for contents that 'ends with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).endsWith((String)value);
                    break;
                }
                case STARTS_WITH: {
                    if (t.getType() != WikittyTypes.STRING) {
                        throw new WikittyException("Can't search for contents that 'starts with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).startsWith((String)value);
                }
            }
            return checked;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.Null) {
            org.nuiton.wikitty.search.operators.Null nullRes = (org.nuiton.wikitty.search.operators.Null)restriction;
            String fqfieldName = nullRes.getFieldName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            if (fqfieldName.equals(org.nuiton.wikitty.search.operators.Element.ELT_EXTENSION)) {
                return false;
            }
            if (fqfieldName.equals(org.nuiton.wikitty.search.operators.Element.ELT_ID)) {
                return false;
            }
            boolean checked = false;
            switch (nullRes.getName()) {
                case IS_NULL: {
                    checked = o == null;
                    break;
                }
                case IS_NOT_NULL: {
                    checked = o != null;
                }
            }
            return checked;
        }
        if (restriction instanceof In) {
            In in = (In)restriction;
            String fqfieldName = in.getElement().getName();
            String testedValue = String.valueOf(w.getFqField(fqfieldName));
            for (String value : in.getValue()) {
                if (!testedValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.True) {
            return true;
        }
        if (restriction instanceof False) {
            return false;
        }
        if (restriction instanceof Contains) {
            String fieldName;
            Contains contains = (Contains)restriction;
            String fqfieldName = contains.getElement().getName();
            List<String> values = contains.getValue();
            String extension = WikittyUtil.getExtensionNameFromFQFieldName(fqfieldName);
            if (!w.hasField(extension, fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqfieldName))) {
                return false;
            }
            String testedValuesAsString = w.getFieldAsString(extension, fieldName);
            if ('[' == testedValuesAsString.charAt(0)) {
                testedValuesAsString = testedValuesAsString.substring(1, testedValuesAsString.length());
            }
            List<String> testedValues = Arrays.asList(testedValuesAsString.split(","));
            for (String value : values) {
                if (testedValues.contains(String.valueOf(value))) continue;
                return false;
            }
            return true;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.And) {
            org.nuiton.wikitty.search.operators.And and = (org.nuiton.wikitty.search.operators.And)restriction;
            for (Restriction sub : and.getRestrictions()) {
                if (this.checkRestriction(transaction, sub, w)) continue;
                return false;
            }
            return true;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.Or) {
            org.nuiton.wikitty.search.operators.Or or = (org.nuiton.wikitty.search.operators.Or)restriction;
            for (Restriction sub : or.getRestrictions()) {
                if (!this.checkRestriction(transaction, sub, w)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.Keyword) {
            org.nuiton.wikitty.search.operators.Keyword keyword = (org.nuiton.wikitty.search.operators.Keyword)restriction;
            String value = keyword.getValue();
            for (String fieldName : w.getAllFieldNames()) {
                String testedValue = String.valueOf(w.getFqField(fieldName));
                if (!testedValue.contains(value)) continue;
                return true;
            }
            return false;
        }
        if (restriction instanceof org.nuiton.wikitty.search.operators.Not) {
            org.nuiton.wikitty.search.operators.Not or = (org.nuiton.wikitty.search.operators.Not)restriction;
            Restriction sub = or.getRestriction();
            return !this.checkRestriction(transaction, sub, w);
        }
        if (restriction instanceof AssociatedRestriction) {
            AssociatedRestriction ass = (AssociatedRestriction)restriction;
            String fqfieldName = ass.getElement().getName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            Restriction sub = ass.getRestriction();
            Criteria associatedSearch = new Criteria();
            associatedSearch.setRestriction(sub);
            PagedResult<String> associatedResult = this.findAllByCriteria(transaction, associatedSearch);
            List<String> associatedList = associatedResult.getAll();
            return associatedList.contains(String.valueOf(o));
        }
        if (restriction instanceof Between) {
            Between op = (Between)restriction;
            Set<String> max = op.getMax();
            Set<String> min = op.getMin();
            if (op.getElement().getName().equals(org.nuiton.wikitty.search.operators.Element.ELT_EXTENSION)) {
                return false;
            }
            if (op.getElement().getName().equals(org.nuiton.wikitty.search.operators.Element.ELT_ID)) {
                return false;
            }
            String fqfieldName = op.getElement().getName();
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            FieldType t = w.getFieldType(fqfieldName);
            if (!(min instanceof Collection) && t.isCollection()) {
                min = Collections.singleton(min);
            }
            min = t.getValidValue(min);
            if (!(max instanceof Collection) && t.isCollection()) {
                max = Collections.singleton(max);
            }
            max = t.getValidValue(max);
            return ((Comparable)o).compareTo(min) >= 0 && ((Comparable)o).compareTo(max) <= 0;
        }
        throw new UnsupportedOperationException((Object)((Object)restriction.getName()) + " Search Not yet implemented");
    }

    public static class WikittyQueryVisitorCheckCondition
    extends WikittyQueryVisitor {
        protected WikittySearchEngine searchEngine;
        protected WikittyTransaction tx;
        protected Wikitty w;
        protected Deque<Boolean> evalStack = new LinkedList<Boolean>();
        private static Predicate BetweenPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    result = false;
                    if (values == null || expected.size() != 2) break block1;
                    Iterator i = expected.iterator();
                    Object min = i.next();
                    Object max = i.next();
                    Iterator i$ = values.iterator();
                    while (!(!i$.hasNext() || (fieldValue = i$.next()) instanceof Comparable && (result = ((Comparable)fieldValue).compareTo(min) >= 0 && ((Comparable)fieldValue).compareTo(max) <= 0))) {
                    }
                }
                return result;
            }
        };
        private static Predicate ContainsAllPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = false;
                if (values != null) {
                    expected = CollectionUtils.subtract((Collection)expected, (Collection)values);
                    result = expected.isEmpty();
                }
                return result;
            }
        };
        private static Predicate ContainsOnePredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = false;
                if (values != null) {
                    result = !(expected = CollectionUtils.retainAll((Collection)expected, (Collection)values)).isEmpty();
                }
                return result;
            }
        };
        private static Predicate EqualsPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = false;
                if (values != null && expected.size() > 0) {
                    if (type != null && type.getType() == WikittyTypes.STRING) {
                        Object fieldValue;
                        String val;
                        Iterator i = expected.iterator();
                        String exp = String.valueOf(i.next());
                        Iterator i$ = values.iterator();
                        while (i$.hasNext() && !(result = WikittyQueryVisitorCheckCondition.matchString(val = String.valueOf(fieldValue = i$.next()), exp, false))) {
                        }
                    } else {
                        expected = CollectionUtils.subtract((Collection)expected, (Collection)values);
                        result = expected.isEmpty();
                    }
                }
                return result;
            }
        };
        private static Predicate EqualsIgnoreCaseAndAccentPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = false;
                if (values != null && expected.size() > 0) {
                    if (type != null && type.getType() == WikittyTypes.STRING) {
                        Object fieldValue;
                        String val;
                        Iterator i = expected.iterator();
                        String exp = String.valueOf(i.next());
                        Iterator i$ = values.iterator();
                        while (i$.hasNext() && !(result = WikittyQueryVisitorCheckCondition.matchString(val = String.valueOf(fieldValue = i$.next()), exp, true))) {
                        }
                    } else {
                        expected = CollectionUtils.subtract((Collection)expected, (Collection)values);
                        result = expected.isEmpty();
                    }
                }
                return result;
            }
        };
        private static Predicate GreaterPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    Object val = i.next();
                    Iterator i$ = values.iterator();
                    while (!(!i$.hasNext() || (fieldValue = i$.next()) instanceof Comparable && (result = ((Comparable)fieldValue).compareTo(val) > 0))) {
                    }
                }
                return result;
            }
        };
        private static Predicate GreaterOrEqualsPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    Object val = i.next();
                    Iterator i$ = values.iterator();
                    while (!(!i$.hasNext() || (fieldValue = i$.next()) instanceof Comparable && (result = ((Comparable)fieldValue).compareTo(val) >= 0))) {
                    }
                }
                return result;
            }
        };
        private static Predicate LessPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    Object val = i.next();
                    Iterator i$ = values.iterator();
                    while (!(!i$.hasNext() || (fieldValue = i$.next()) instanceof Comparable && (result = ((Comparable)fieldValue).compareTo(val) < 0))) {
                    }
                }
                return result;
            }
        };
        private static Predicate LessOrEqualsPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    Object val = i.next();
                    Iterator i$ = values.iterator();
                    while (!(!i$.hasNext() || (fieldValue = i$.next()) instanceof Comparable && (result = ((Comparable)fieldValue).compareTo(val) <= 0))) {
                    }
                }
                return result;
            }
        };
        private static Predicate KeywordPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    String val;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    String exp = String.valueOf(i.next());
                    Iterator i$ = values.iterator();
                    while (i$.hasNext() && !(result = WikittyQueryVisitorCheckCondition.matchString(val = String.valueOf(fieldValue = i$.next()), exp, true))) {
                    }
                }
                return result;
            }
        };
        private static Predicate LikePredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result;
                block1: {
                    Object fieldValue;
                    String val;
                    result = false;
                    if (values == null || expected.size() <= 0) break block1;
                    Iterator i = expected.iterator();
                    String exp = String.valueOf(i.next());
                    Iterator i$ = values.iterator();
                    while (i$.hasNext() && !(result = WikittyQueryVisitorCheckCondition.matchString(val = String.valueOf(fieldValue = i$.next()), exp, true))) {
                    }
                }
                return result;
            }
        };
        private static Predicate NullPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = values == null || values.contains(null);
                return result;
            }
        };
        private static Predicate NotNullPredicate = new Predicate(){

            @Override
            public boolean check(FieldType type, Collection values, Collection expected) {
                boolean result = values != null && !values.contains(null);
                return result;
            }
        };

        public boolean getResult() {
            Boolean result = this.evalStack.poll();
            if (result == null) {
                result = Boolean.TRUE;
            }
            return result;
        }

        public WikittyQueryVisitorCheckCondition(WikittySearchEngine searchEngine, WikittyTransaction tx, Wikitty w) {
            this.searchEngine = searchEngine;
            this.tx = tx;
            this.w = w;
        }

        private static boolean matchString(String s, String sub, boolean ignoreCaseAndAccent) {
            if (ignoreCaseAndAccent) {
                s = StringUtils.stripAccents((String)s);
                s = s.toLowerCase();
                sub = StringUtils.stripAccents((String)sub);
                sub = sub.toLowerCase();
            }
            sub = sub.replaceAll("\\*", ".*");
            sub = sub.replaceAll("\\?", ".");
            boolean result = s.matches(sub);
            return result;
        }

        protected void collectFieldValue(Element e, Map<String, Collection> values) {
            block5: {
                String fieldName;
                String extName;
                block9: {
                    block8: {
                        String fqf;
                        block7: {
                            block6: {
                                block4: {
                                    if (!(e instanceof ElementId)) break block4;
                                    values.put(e.getValue(), Collections.singleton(this.w.getWikittyId()));
                                    break block5;
                                }
                                if (!(e instanceof ElementExtension)) break block6;
                                values.put(e.getValue(), this.w.getExtensionNames());
                                break block5;
                            }
                            fqf = e.getValue();
                            if (!this.w.hasField(fqf)) break block7;
                            Object v = this.w.getFqField(fqf);
                            values.put(fqf, this.convert(null, v));
                            break block5;
                        }
                        extName = WikittyExtension.extractExtensionName(fqf);
                        fieldName = WikittyExtension.extractFieldName(fqf);
                        if (!"*".equals(extName) || !"*".equals(fieldName)) break block8;
                        for (String f : this.w.getAllFieldNames()) {
                            Object v = this.w.getFqField(f);
                            values.put(f, this.convert(null, v));
                        }
                        break block5;
                    }
                    if (!"*".equals(fieldName)) break block9;
                    for (String f : this.w.getExtension(extName).getFieldNames()) {
                        String fq = WikittyUtil.getFQFieldName(extName, f);
                        Object v = this.w.getFqField(fq);
                        values.put(fq, this.convert(null, v));
                    }
                    break block5;
                }
                if (!"*".equals(extName)) break block5;
                for (String ext : this.w.getExtensionNames()) {
                    for (String f : this.w.getExtension(ext).getFieldNames()) {
                        if (!f.equals(fieldName)) continue;
                        String fq = WikittyUtil.getFQFieldName(ext, f);
                        Object v = this.w.getFqField(fq);
                        values.put(fq, this.convert(null, v));
                    }
                }
            }
        }

        protected Collection<Object> convert(FieldType type, Object o) {
            Set<Object> result;
            block8: {
                try {
                    if (o instanceof Collection) {
                        if (type == null) {
                            result = new LinkedHashSet<Object>((Collection)o);
                        } else {
                            result = new LinkedHashSet<Object>();
                            for (Object v : (Collection)o) {
                                result.add(type.getContainedValidObject(v));
                            }
                        }
                    } else {
                        if (type != null) {
                            o = type.getContainedValidObject(o);
                        }
                        result = Collections.singleton(o);
                    }
                }
                catch (Exception eee) {
                    result = null;
                    if (!log.isTraceEnabled()) break block8;
                    log.trace((Object)"not an error but can't convert string to wanted type", (Throwable)eee);
                }
            }
            return result;
        }

        protected boolean check(Predicate predicate, Element element, Object expected) {
            if (element instanceof ElementField) {
                String fqf = element.getValue();
                String extName = WikittyUtil.getExtensionNameFromFQFieldName(fqf);
                String fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqf);
                fqf = WikittyUtil.getFQFieldName(extName, fieldName);
                element = Element.get(fqf);
            }
            boolean result = false;
            boolean isIndexed = true;
            HashMap<String, Collection> fieldValues = new HashMap<String, Collection>();
            this.collectFieldValue(element, fieldValues);
            for (String fqf : fieldValues.keySet()) {
                Collection values;
                FieldType type = null;
                if (this.w.hasField(fqf)) {
                    type = this.w.getFieldType(fqf);
                    isIndexed = type.isIndexed();
                }
                Collection<Object> contained = this.convert(type, expected);
                if (!isIndexed || contained == null || !(result = predicate.check(type, values = (Collection)fieldValues.get(fqf), contained))) continue;
                break;
            }
            return result;
        }

        @Override
        public void visit(ConditionValueString o) {
        }

        @Override
        public boolean visitEnter(WikittyQuery o) {
            return true;
        }

        @Override
        public void visitLeave(WikittyQuery o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(And o) {
            this.evalStack.push(Boolean.TRUE);
            return true;
        }

        @Override
        public boolean visitMiddle(And o) {
            Boolean last = this.evalStack.pop();
            Boolean currentValue = this.evalStack.pop();
            Boolean result = currentValue != false && last != false;
            this.evalStack.push(result);
            return result;
        }

        @Override
        public void visitLeave(And o, boolean enterOrMiddleResult) {
            Boolean currentValue;
            Boolean last = Boolean.TRUE;
            if (enterOrMiddleResult && o.getConditions().size() > 0) {
                last = this.evalStack.pop();
            }
            Boolean result = (currentValue = this.evalStack.pop()) != false && last != false;
            this.evalStack.push(result);
        }

        @Override
        public boolean visitEnter(Or o) {
            if (o.getConditions().isEmpty()) {
                this.evalStack.push(Boolean.TRUE);
            } else {
                this.evalStack.push(Boolean.FALSE);
            }
            return true;
        }

        @Override
        public boolean visitMiddle(Or o) {
            Boolean last = this.evalStack.pop();
            Boolean currentValue = this.evalStack.pop();
            Boolean result = currentValue != false || last != false;
            this.evalStack.push(result);
            return result == false;
        }

        @Override
        public void visitLeave(Or o, boolean enterOrMiddleResult) {
            Boolean currentValue;
            Boolean last = Boolean.TRUE;
            if (enterOrMiddleResult && o.getConditions().size() > 0) {
                last = this.evalStack.pop();
            }
            Boolean result = (currentValue = this.evalStack.pop()) != false || last != false;
            this.evalStack.push(result);
        }

        @Override
        public boolean visitEnter(Select o) {
            return true;
        }

        @Override
        public void visitLeave(Select o, boolean enterOrMiddleResult) {
        }

        protected List<String> evalConditionValueAsList(List<ConditionValue> o) {
            ArrayList<String> result = new ArrayList<String>(o.size());
            for (ConditionValue c : o) {
                result.addAll(this.evalConditionValueAsList(c));
            }
            return result;
        }

        protected List<String> evalConditionValueAsList(ConditionValue o) {
            ArrayList<String> result = new ArrayList<String>();
            if (o instanceof Select) {
                WikittyQuery query = new WikittyQuery(o);
                WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
                result.addAll(selectResult.getAll());
            } else if (o instanceof ConditionValueString) {
                result.add(((ConditionValueString)o).getValue());
            } else {
                throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
            }
            return result;
        }

        protected String evalConditionValue(ConditionValue o) {
            String result;
            if (o instanceof Select) {
                WikittyQuery query = new WikittyQuery(o);
                WikittyQueryResult<String> selectResult = this.searchEngine.findAllByQuery(this.tx, query);
                if (selectResult.size() == 0) {
                    throw new WikittyException(String.format("Select return no result query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
                }
                if (selectResult.size() > 1 && log.isWarnEnabled()) {
                    log.warn((Object)String.format("Select return more than one result, only first is used. Query was '%s' transformed to '%s'", o.toString(), selectResult.getQueryString()));
                }
                result = selectResult.peek();
            } else if (o instanceof ConditionValueString) {
                result = ((ConditionValueString)o).getValue();
            } else {
                throw new WikittyException(String.format("ConditionValue type unsupported %s", ClassUtils.getShortCanonicalName((Object)o, (String)"null")));
            }
            return result;
        }

        @Override
        public boolean visitEnter(Not o) {
            return true;
        }

        @Override
        public void visitLeave(Not o, boolean enterOrMiddleResult) {
            Boolean val = this.evalStack.pop();
            Boolean result = val == false;
            this.evalStack.push(result);
        }

        @Override
        public boolean visitEnter(org.nuiton.wikitty.query.conditions.Between o) {
            boolean result = false;
            ArrayList<String> expected = new ArrayList<String>(2);
            expected.add(this.evalConditionValue(o.getMin()));
            expected.add(this.evalConditionValue(o.getMax()));
            result = this.check(BetweenPredicate, o.getElement(), expected);
            this.evalStack.push(result);
            return false;
        }

        @Override
        public boolean visitMiddle(org.nuiton.wikitty.query.conditions.Between o) {
            return false;
        }

        @Override
        public void visitLeave(org.nuiton.wikitty.query.conditions.Between o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(ContainsAll o) {
            boolean result = false;
            result = this.check(ContainsAllPredicate, o.getElement(), this.evalConditionValueAsList(o.getValues()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public boolean visitMiddle(ContainsAll o) {
            return false;
        }

        @Override
        public void visitLeave(ContainsAll o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(ContainsOne o) {
            boolean result = false;
            result = this.check(ContainsOnePredicate, o.getElement(), this.evalConditionValueAsList(o.getValues()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public boolean visitMiddle(ContainsOne o) {
            return false;
        }

        @Override
        public void visitLeave(ContainsOne o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(Equals o) {
            boolean result = false;
            result = o.isIgnoreCaseAndAccent() ? this.check(EqualsIgnoreCaseAndAccentPredicate, o.getElement(), this.evalConditionValue(o.getValue())) : this.check(EqualsPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Equals o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(NotEquals o) {
            boolean result = false;
            result = o.isIgnoreCaseAndAccent() ? !this.check(EqualsIgnoreCaseAndAccentPredicate, o.getElement(), this.evalConditionValue(o.getValue())) : !this.check(EqualsPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(NotEquals o, boolean enterOrMiddleResult) {
        }

        @Override
        public void visit(org.nuiton.wikitty.query.conditions.False o) {
            this.evalStack.push(Boolean.FALSE);
        }

        @Override
        public void visit(True o) {
            this.evalStack.push(Boolean.TRUE);
        }

        @Override
        public boolean visitEnter(Greater o) {
            boolean result = false;
            result = this.check(GreaterPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Greater o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(GreaterOrEquals o) {
            boolean result = false;
            result = this.check(GreaterOrEqualsPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(GreaterOrEquals o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(Keyword o) {
            boolean result = false;
            result = this.check(KeywordPredicate, o.getElement(), "*" + this.evalConditionValue(o.getValue()) + "*");
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Keyword o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(Less o) {
            boolean result = false;
            result = this.check(LessPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Less o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(LessOrEquals o) {
            boolean result = false;
            result = this.check(LessOrEqualsPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(LessOrEquals o, boolean enterOrMiddleResult) {
            boolean result = false;
            result = this.check(LessOrEqualsPredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
        }

        @Override
        public boolean visitEnter(Like o) {
            boolean result = false;
            result = this.check(LikePredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Like o, boolean enterOrMiddleResult) {
        }

        @Override
        public boolean visitEnter(Unlike o) {
            boolean result = false;
            result = !this.check(LikePredicate, o.getElement(), this.evalConditionValue(o.getValue()));
            this.evalStack.push(result);
            return false;
        }

        @Override
        public void visitLeave(Unlike o, boolean enterOrMiddleResult) {
        }

        @Override
        public void visit(Null o) {
            boolean result = false;
            result = this.check(NullPredicate, o.getElement(), null);
            this.evalStack.push(result);
        }

        @Override
        public void visit(NotNull o) {
            boolean result = false;
            result = this.check(NotNullPredicate, o.getElement(), null);
            this.evalStack.push(result);
        }

        @Override
        public void defaultVisit(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean defaultVisitEnter(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean defaultVisitMiddle(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void defaultVisitLeave(Object o, boolean enterOrMiddleResult) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static interface Predicate {
            public boolean check(FieldType var1, Collection var2, Collection var3);
        }
    }

    public static class FacetPredicate {
        WikittyTransaction tx;
        WikittySearchEngine searchEngine;
        WikittyQuery query;
        Map<String, Multiset> topic;

        public FacetPredicate(WikittySearchEngine searchEngine, WikittyTransaction tx, WikittyQuery query) {
            this.searchEngine = searchEngine;
            this.tx = tx;
            this.query = query;
            this.topic = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

                public Object create() {
                    return TreeMultiset.create(genericComparator);
                }
            });
        }

        public Map<String, List<FacetTopic>> getFacets() {
            HashMap<String, List<FacetTopic>> result = new HashMap<String, List<FacetTopic>>();
            for (String facetName : this.topic.keySet()) {
                List<FacetTopic> list = new ArrayList();
                Multiset b = this.topic.get(facetName);
                for (Object topicName : b.elementSet()) {
                    int count = b.count(topicName);
                    if (count < this.query.getFacetMinCount()) continue;
                    FacetTopic ft = new FacetTopic(facetName, String.valueOf(topicName), count);
                    list.add(ft);
                }
                if (this.query.getFacetSort() == FacetSortType.count) {
                    Collections.sort(list, this.query.getFacetSort().compartor);
                }
                if (list.size() > this.query.getFacetLimit()) {
                    list = list.subList(0, this.query.getFacetLimit());
                }
                result.put(facetName, list);
            }
            return result;
        }

        public boolean add(Wikitty w) {
            String facetName;
            boolean result = false;
            if (this.query.isFacetExtension()) {
                String facetName2 = ElementExtension.EXTENSION.getValue();
                for (String extName : w.getExtensionNames()) {
                    this.topic.get(facetName2).add((Object)extName);
                    result = true;
                }
            }
            for (Element e : this.query.getFacetField()) {
                if (ElementExtension.EXTENSION.equals(e)) {
                    facetName = ElementExtension.EXTENSION.getValue();
                    for (String extName : w.getExtensionNames()) {
                        this.topic.get(facetName).add((Object)extName);
                        result = true;
                    }
                    continue;
                }
                String fqf = e.getValue();
                Object value = w.getFqField(fqf);
                if (value == null) continue;
                if (value instanceof Collection) {
                    this.topic.get(fqf).addAll((Collection)value);
                } else {
                    this.topic.get(fqf).add(value);
                }
                result = true;
            }
            for (FacetQuery q : this.query.getFacetQuery()) {
                if (!WikittySearchEngineInMemory.checkRestriction(this.searchEngine, this.tx, q.getCondition(), w)) continue;
                facetName = q.getName();
                if (facetName == null) {
                    facetName = q.getCondition().toString();
                }
                this.topic.get(facetName).add((Object)facetName);
                result = true;
            }
            return result;
        }
    }

    public static class WikittyComparator
    implements Comparator<Wikitty> {
        protected List<Element> asc;
        protected List<Element> desc;

        public WikittyComparator(List<Element> asc, List<Element> desc) {
            this.asc = asc;
            this.desc = desc;
        }

        protected int compareValue(Wikitty o1, Wikitty o2, Element e, boolean asc) {
            Object v1 = o1.getFqField(e.getValue());
            Object v2 = o2.getFqField(e.getValue());
            int result = genericComparator.compare(v1, v2);
            if (!asc) {
                result *= -1;
            }
            return result;
        }

        @Override
        public int compare(Wikitty o1, Wikitty o2) {
            int result = 0;
            for (Element e : this.asc) {
                result = this.compareValue(o1, o2, e, true);
                if (result == 0) continue;
                return result;
            }
            for (Element e : this.desc) {
                result = this.compareValue(o1, o2, e, false);
                if (result == 0) continue;
                return result;
            }
            return result;
        }
    }
}

