/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

public class WikittyExtensionMigrationTest {
    private static Log log = LogFactory.getLog(WikittyExtensionMigrationTest.class);
    protected static String extensionName = "Dummy";

    @Test
    public void testMigration() throws Exception {
        WikittyExtension ext1 = new WikittyExtension(extensionName, "1.0", WikittyUtil.tagValuesToMap((String)" version=\"1.0\""), (List)null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"Numeric number", "String string", "Date date"}));
        WikittyExtension ext2 = new WikittyExtension(extensionName, "2.0", WikittyUtil.tagValuesToMap((String)" version=\"1.0\""), (List)null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"Numeric number", "String string", "Date date"}));
        ApplicationConfig config = WikittyConfig.getConfig();
        String key = WikittyConfigOption.WIKITTY_MIGRATION_CLASS.getKey() + extensionName;
        config.setOption(key, DummyMigration.class.getName());
        WikittyServiceInMemory service = new WikittyServiceInMemory(config);
        WikittyClient client = new WikittyClient(config, (WikittyService)service);
        WikittyImpl w1 = new WikittyImpl("w1");
        w1.addExtension(ext1);
        w1.setField(extensionName, "string", (Object)"coucou");
        client.store((Wikitty)w1);
        client.storeExtension(ext2);
        Wikitty w2 = client.restore(w1.getWikittyId(), new String[0]);
        Assert.assertEquals((Object)"hello", (Object)w2.getFieldAsString(extensionName, "string"));
    }

    public static class DummyMigration
    extends WikittyExtensionMigrationRename {
        public Wikitty migrate(WikittyService service, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            System.out.println(String.format("migrate %s(%s) oldExt %s newExt %s", wikitty.getWikittyId(), wikitty.getExtension(extensionName).getId(), oldExt.getId(), newExt.getId()));
            Wikitty result = super.migrate(service, wikitty, oldExt, newExt);
            result.setField(extensionName, "string", (Object)"hello");
            result.setField(extensionName, "date", (Object)new Date());
            System.out.println(String.format("done %s(%s)", result.getWikittyId(), result.getExtension(extensionName).getId()));
            return result;
        }
    }
}

