/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyClientTest;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserImpl;
import org.nuiton.wikitty.services.WikittyCache;
import org.nuiton.wikitty.services.WikittyCacheJCS;
import org.nuiton.wikitty.services.WikittyServiceCached;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.test.Product;

public class WikittyServiceCachedTest
extends WikittyClientTest {
    @Override
    protected WikittyClient getWikittyClient() {
        wikittyConfig.setOption(WikittyConfigOption.JCS_DEFAULT_CACHEATTRIBUTES_MAXOBJECTS.getKey(), "10");
        WikittyServiceInMemory wikittyService = new WikittyServiceInMemory(wikittyConfig);
        wikittyService = new WikittyServiceCached(wikittyConfig, (WikittyService)wikittyService, (WikittyCache)new WikittyCacheJCS(wikittyConfig));
        WikittyClient client = new WikittyClient(wikittyConfig, (WikittyService)wikittyService);
        return client;
    }

    @Test
    public void testCache() throws Exception {
        List<Object> toStore = new ArrayList<WikittyUserImpl>();
        ArrayList<String> toRestore = new ArrayList<String>();
        WikittyUserImpl u1 = new WikittyUserImpl();
        WikittyUserImpl u2 = new WikittyUserImpl();
        WikittyUserImpl u3 = new WikittyUserImpl();
        WikittyUserImpl u4 = new WikittyUserImpl();
        WikittyUserImpl u5 = new WikittyUserImpl();
        toStore.add(u1);
        toStore.add(u2);
        toStore.add(u3);
        toStore.add(u4);
        toStore.add(u5);
        toStore = this.wikittyClient.store(toStore);
        u1 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u1.getWikittyId(), new String[0]);
        u2 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u2.getWikittyId(), new String[0]);
        u3 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u3.getWikittyId(), new String[0]);
        u4 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u4.getWikittyId(), new String[0]);
        u5 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u5.getWikittyId(), new String[0]);
        u1 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u1.getWikittyId(), new String[0]);
        u2 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u2.getWikittyId(), new String[0]);
        u3 = (WikittyUser)this.wikittyClient.restore(WikittyUser.class, u3.getWikittyId(), new String[0]);
        toRestore.add(u1.getWikittyId());
        toRestore.add(u2.getWikittyId());
        toRestore.add(u3.getWikittyId());
        toRestore.add(u4.getWikittyId());
        toRestore.add(u5.getWikittyId());
        this.wikittyClient.restore(WikittyUser.class, toRestore, new String[0]);
    }

    @Test
    public void testCacheRestore() throws IOException {
        this.importBooks();
        Product book = (Product)this.wikittyClient.restore(Product.class, "4d221e31-ff9b-44f0-8545-f9884435f30d", new String[0]);
        Assert.assertNotNull((Object)book);
        book.setName("My new name");
        book = (Product)this.wikittyClient.restore(Product.class, "4d221e31-ff9b-44f0-8545-f9884435f30d", new String[0]);
        Assert.assertEquals((Object)"Harry Potter \u00e0 l'\u00e9cole des sorciers", (Object)book.getName());
    }

    @Test
    public void testCacheRestoreMultipleIds() throws IOException {
        this.importBooks();
        ArrayList<String> idsToRestore = new ArrayList<String>();
        idsToRestore.add("4d221e31-ff9b-44f0-8545-f9884435f30d");
        List otherWikitties = this.wikittyClient.restore(Product.class, idsToRestore, new String[0]);
        Product book = (Product)otherWikitties.get(0);
        book.setName("My new name");
        otherWikitties = this.wikittyClient.restore(Product.class, idsToRestore, new String[0]);
        book = (Product)otherWikitties.get(0);
        Assert.assertEquals((Object)"Harry Potter \u00e0 l'\u00e9cole des sorciers", (Object)book.getName());
    }

    @Test
    public void testRestoreNoCopyPolicy() {
        Wikitty anotherWikitty = this.wikittyClient.restore("4d221e31-ff9b-44f0-8545-f9884435f30d", new String[0]);
        Wikitty yetAnotherWikitty = this.wikittyClient.restore("4d221e31-ff9b-44f0-8545-f9884435f30d", new String[0]);
        Assert.assertSame((Object)anotherWikitty, (Object)yetAnotherWikitty);
    }
}

