/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;

public class FieldType
implements Serializable {
    private static final long serialVersionUID = -4375308750387837026L;
    public static String UNIQUE = "unique";
    public static String NOT_NULL = "notNull";
    public static final int NOLIMIT = Integer.MAX_VALUE;
    protected TYPE type;
    protected int lowerBound;
    protected int upperBound;
    Map<String, String> tagValues = new HashMap<String, String>();

    public FieldType() {
    }

    public FieldType(TYPE type, int lowerBound, int upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void addTagValue(String tag, String value) {
        this.tagValues.put(tag, value);
    }

    public String getTagValue(String tag) {
        String result = this.tagValues.get(tag);
        return result;
    }

    public Set<String> getTagNames() {
        return this.tagValues.keySet();
    }

    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    public void setTagValues(Map<String, String> tagValues) {
        this.tagValues = tagValues;
    }

    public boolean isCollection() {
        return this.upperBound > 1;
    }

    public String toDefinition(String name) {
        String result = (Object)((Object)this.type) + " " + name;
        if (this.lowerBound != 0 || this.upperBound != 0) {
            result = this.upperBound != Integer.MAX_VALUE ? result + "[" + this.lowerBound + "-" + this.upperBound + "]" : result + "[" + this.lowerBound + "-*]";
        }
        result = result + WikittyUtil.tagValuesToString(this.tagValues);
        return result;
    }

    public Object getContainedValidObject(Object value) {
        Object result = null;
        switch (this.type) {
            case BINARY: {
                result = WikittyUtil.toBinary(value);
                break;
            }
            case DATE: {
                result = WikittyUtil.toDate(value);
                break;
            }
            case NUMERIC: {
                result = WikittyUtil.toBigDecimal(value);
                break;
            }
            case BOOLEAN: {
                result = WikittyUtil.toBoolean(value);
                break;
            }
            case STRING: {
                result = WikittyUtil.toString(value);
                break;
            }
            default: {
                result = WikittyUtil.toWikitty(value);
            }
        }
        return result;
    }

    public Object getValidValue(Object value) throws WikittyException {
        AbstractCollection result;
        if (value == null && this.isNotNull()) {
            throw new WikittyException("Value can't be null for this field");
        }
        if (value == null) {
            result = null;
        } else if (this.isCollection()) {
            if (!(value instanceof Collection)) {
                throw new WikittyException("A collection is expected for type " + this.type.name() + "[" + this.lowerBound + " - " + this.upperBound + "]");
            }
            AbstractCollection col = this.isUnique() ? new LinkedHashSet() : new ArrayList();
            for (Object o : (Collection)value) {
                col.add(this.getContainedValidObject(o));
            }
            result = col;
            if (this.getLowerBound() > col.size() || col.size() > this.getUpperBound()) {
                throw new WikittyException(String.format("Can't set collection value, bad size collection: %s <= %s <= %s is false", this.getLowerBound(), col.size(), this.getUpperBound()));
            }
        } else {
            result = this.getContainedValidObject(value);
        }
        return result;
    }

    public boolean isValidValue(Object value) {
        return this.getValidValue(value) != null;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isUnique() {
        return "true".equalsIgnoreCase(this.getTagValue(UNIQUE));
    }

    public boolean isNotNull() {
        return "true".equalsIgnoreCase(this.getTagValue(NOT_NULL));
    }

    public static enum TYPE {
        BINARY,
        BOOLEAN,
        DATE,
        NUMERIC,
        STRING,
        WIKITTY;


        public static TYPE parse(String name) {
            TYPE result = TYPE.valueOf(name.trim().toUpperCase());
            return result;
        }
    }
}

