package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class HorseHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private HorseHelper() {// empty
}

    public static int getLegs(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Horse.EXT_HORSE, Horse.FIELD_HORSE_LEGS);
        return value;
}

    public static int setLegs(Wikitty wikitty, int legs) {
        int oldValue = getLegs(wikitty);
        wikitty.setField(Horse.EXT_HORSE, Horse.FIELD_HORSE_LEGS, legs);
        return oldValue;
}

    public static String getColor(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Horse.EXT_HORSE, Horse.FIELD_HORSE_COLOR);
        return value;
}

    public static String setColor(Wikitty wikitty, String color) {
        String oldValue = getColor(wikitty);
        wikitty.setField(Horse.EXT_HORSE, Horse.FIELD_HORSE_COLOR, color);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Horse.EXT_HORSE, Horse.FIELD_HORSE_LEGS);
            Object f2 = w2.getFieldAsObject(Horse.EXT_HORSE, Horse.FIELD_HORSE_LEGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Horse.EXT_HORSE, Horse.FIELD_HORSE_COLOR);
            Object f2 = w2.getFieldAsObject(Horse.EXT_HORSE, Horse.FIELD_HORSE_COLOR);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Horse.EXT_HORSE);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : HorseAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Horse.EXT_HORSE);
}

} //HorseHelper
