package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class CategoryEntityAbstract extends BusinessEntityImpl implements CategoryEntity {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionCategoryEntity;

    @Override
    public String getName() {
String value = CategoryEntityHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
CategoryEntityHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(CategoryEntity.FIELD_CATEGORYENTITY_NAME, oldValue, getName());
}

    public CategoryEntityAbstract() {
        super();
}

    public CategoryEntityAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public CategoryEntityAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionCategoryEntity = new WikittyExtension(EXT_CATEGORYENTITY,
                "0.1", // version
                WikittyUtil.tagValuesToMap(" version=\"0.1\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionCategoryEntity);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return CategoryEntityHelper.toString(getWikitty());
}

} //CategoryEntityAbstract
