/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: PerformanceBenchMark.java 1136 2011-08-12 14:24:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.3/wikitty-api/src/test/java/org/nuiton/wikitty/conform/PerformanceBenchMark.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.wikitty.conform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;

/**
 * This class is <strong>NOT</strong> a test. It's a benchlark that
 * computes values and log them.  This class is named properly to
 * prevent any test Runner to run it.
 *
 * @author ruchaud
 * @version $Revision: 1136 $
 *
 * Last update: $Date: 2011-08-12 16:24:03 +0200 (Fri, 12 Aug 2011) $
 * by : $Author: tchemit $
 */
public class PerformanceBenchMark {

    protected final static Log log = LogFactory.getLog(PerformanceBenchMark.class);

    protected final static int WIKITTY_SIZE = 10000;

    static protected WikittyService ws;

    @BeforeClass
    static public void loadWikittyService() throws Exception {
        ApplicationConfig config = WikittyConfig.getConfig(); // default config for in memory
//        String msg = "Try to passe test with "+ config.getPrintableConfig("wikitty.*", 50);
//        log.info(msg);
        ws = WikittyServiceFactory.buildWikittyService(config);
    }

    @Before
    public void clearStorage() throws Exception {
        ws.clear(null);
    }

    @Test
    public void testPerformanceWikitty() throws Exception {
        testPerformanceWikitty(3);
        testPerformanceWikitty(50);
        testPerformanceWikitty(100);
    }

    protected void testPerformanceWikitty(int fieldSize) {
        WikittyExtension extension = new WikittyExtension("Performance" + fieldSize);
        for (int i = 0; i < fieldSize; i++) {
            FieldType fieldType = new FieldType(FieldType.TYPE.STRING, 1, 1);
            extension.addField("field" + i, fieldType);
        }
        ws.storeExtension(null, Arrays.asList(extension));

        Collection<Wikitty> wikitties = new ArrayList<Wikitty>(WIKITTY_SIZE);
        for (int i = 0; i < WIKITTY_SIZE; i++) {
            Wikitty wikitty = new WikittyImpl("Performance" + fieldSize + "id" + i);
            wikitty.addExtension(extension);
            for (int j = 0; j < fieldSize; j++) {
                wikitty.setField("Performance" + fieldSize, "field" + j, "value" + j);
            }
            wikitties.add(wikitty);
        }
        long start = System.currentTimeMillis();
        ws.store(null, wikitties, false);
        long end = System.currentTimeMillis();
        log.info("[Performance" + fieldSize + "] Write times : " + ((end - start) / 1000) + "s");

        Random random = new Random();
        start = System.currentTimeMillis();
        for (int i = 0; i < WIKITTY_SIZE; i++) {
            int nextInt = random.nextInt(WIKITTY_SIZE);
            ws.restore(null, Arrays.asList("Performance" + fieldSize + "id" + nextInt));
        }
        end = System.currentTimeMillis();
        log.info("[Performance" + fieldSize + "] Read times : " + ((end - start) / 1000) + "s");
    }
}
