/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceNotifier;

public class XMPPNotifierTransporter
implements PacketListener,
WikittyServiceNotifier.RemoteNotifierTransporter {
    private static Log log = LogFactory.getLog(XMPPNotifierTransporter.class);
    public static final String PROPERTY_EVENT_NAME = "wikitty-event";
    protected boolean propagateEvent = false;
    protected boolean listenEvent = false;
    protected WikittyServiceNotifier ws;
    protected String room;
    protected String pseudo;
    protected XMPPConnection connection;
    protected MultiUserChat muc;

    public XMPPNotifierTransporter(ApplicationConfig config) {
        this.propagateEvent = config.getOptionAsBoolean(WikittyConfig.WikittyOption.WIKITTY_EVENT_PROPAGATE.getKey());
        this.listenEvent = config.getOptionAsBoolean(WikittyConfig.WikittyOption.WIKITTY_EVENT_LISTEN.getKey());
        this.initXMPP(config);
    }

    public WikittyServiceNotifier getWikittyServiceNotifier() {
        return this.ws;
    }

    @Override
    public void setWikittyServiceNotifier(WikittyServiceNotifier ws) {
        this.ws = ws;
    }

    protected void initXMPP(ApplicationConfig config) {
        if (this.propagateEvent || this.listenEvent) {
            String server = config.getOption(WikittyConfig.WikittyOption.WIKITTY_EVENT_TRANSPORTER_XMPP_SERVER.getKey());
            this.room = config.getOption(WikittyConfig.WikittyOption.WIKITTY_EVENT_TRANSPORTER_XMPP_ROOM.getKey());
            this.pseudo = WikittyUtil.getUniqueLoginName();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Try to connect to xmpp serveur " + server + " with pseudo " + this.pseudo + " in room " + this.room));
                }
                this.connection = new XMPPConnection(server);
                this.connection.connect();
                this.connection.loginAnonymously();
                DiscussionHistory history = new DiscussionHistory();
                history.setMaxChars(0);
                this.muc = new MultiUserChat(this.connection, this.room);
                this.muc.join(this.pseudo, "", history, 4000L);
                if (this.listenEvent) {
                    this.muc.addMessageListener((PacketListener)this);
                }
            }
            catch (Exception eee) {
                throw new WikittyException("Can't connect to xmpp serveur", eee);
            }
        }
    }

    @Override
    public void sendMessage(WikittyEvent event) throws Exception {
        if (this.propagateEvent) {
            Message message = this.muc.createMessage();
            message.setBody(event.getType().toString());
            message.setProperty(PROPERTY_EVENT_NAME, (Object)event);
            this.muc.sendMessage(message);
        }
    }

    public void processPacket(Packet packet) {
        String name = this.room + "/" + this.pseudo;
        if (!name.equals(packet.getFrom())) {
            Object event = packet.getProperty(PROPERTY_EVENT_NAME);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receive message : " + event));
            }
            if (event instanceof WikittyEvent) {
                this.ws.processRemoteEvent((WikittyEvent)event);
            }
        }
    }
}

