/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyLabelHelper {

    /**
     * WikittyLabelHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyLabelHelper() {// empty
}

    /**
     * getLabels :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getLabels(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, String.class);
        return result;
}

    /**
     * setLabels :
     * @param wikitty 
     * @param labels 
     */

    public static void setLabels(Wikitty wikitty, Set<String> labels) {
        clearLabels(wikitty);
        addAllLabels(wikitty, labels);
}

    /**
     * addAllLabels :
     * @param wikitty 
     * @param labels 
     */

    public static void addAllLabels(Wikitty wikitty, Set<String> labels) {
        if(labels != null){
            for (String id:labels){
                addLabels(wikitty, id);
            }
        }
}

    /**
     * addLabels :
     * @param wikitty 
     * @param element 
     */

    public static void addLabels(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, element);
}

    /**
     * removeLabels :
     * @param wikitty 
     * @param element 
     */

    public static void removeLabels(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS, element);
}

    /**
     * clearLabels :
     * @param wikitty 
     */

    public static void clearLabels(Wikitty wikitty) {
        wikitty.clearField(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
            Object f2 = w2.getFieldAsObject(WikittyLabel.EXT_WIKITTYLABEL, WikittyLabel.FIELD_WIKITTYLABEL_LABELS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyLabel.EXT_WIKITTYLABEL);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyLabelAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyLabelHelper
