/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public interface WikittyI18n extends BusinessEntity {     String EXT_WIKITTYI18N = "WikittyI18n";
     String FIELD_WIKITTYI18N_TRANSLATABLEVALUES = "translatableValues";
     String FQ_FIELD_WIKITTYI18N_TRANSLATABLEVALUES = EXT_WIKITTYI18N + ".translatableValues";
     String FIELD_WIKITTYI18N_LANG = "lang";
     String FQ_FIELD_WIKITTYI18N_LANG = EXT_WIKITTYI18N + ".lang";
     String FIELD_WIKITTYI18N_TRANSLATIONS = "translations";
     String FQ_FIELD_WIKITTYI18N_TRANSLATIONS = EXT_WIKITTYI18N + ".translations";
    /**
     * getTranslation :
     * @param lang 
     * @param field 
     * @return String 
     */

     String getTranslation(String lang, String field);

    /**
     * setTranslation :
     * @param lang 
     * @param field 
     * @param trad 
     */

     void setTranslation(String lang, String field, String trad);

    /**
     * getTranslatableValues :
     * @return Set<String> 
     */

     Set<String> getTranslatableValues();

    /**
     * setTranslatableValues :
     * @param translatableValues 
     */

     void setTranslatableValues(Set<String> translatableValues);

    /**
     * addAllTranslatableValues :
     * @param translatableValues 
     */

     void addAllTranslatableValues(Set<String> translatableValues);

    /**
     * addTranslatableValues :
     * @param element 
     */

     void addTranslatableValues(String element);

    /**
     * removeTranslatableValues :
     * @param element 
     */

     void removeTranslatableValues(String element);

    /**
     * clearTranslatableValues :
     */

     void clearTranslatableValues();

    /**
     * getLang :
     * @return Set<String> 
     */

     Set<String> getLang();

    /**
     * setLang :
     * @param lang 
     */

     void setLang(Set<String> lang);

    /**
     * addAllLang :
     * @param lang 
     */

     void addAllLang(Set<String> lang);

    /**
     * addLang :
     * @param element 
     */

     void addLang(String element);

    /**
     * removeLang :
     * @param element 
     */

     void removeLang(String element);

    /**
     * clearLang :
     */

     void clearLang();

    /**
     * getTranslations :
     * @return String 
     */

     String getTranslations();

    /**
     * setTranslations :
     * @param translations 
     */

     void setTranslations(String translations);


} //WikittyI18n
