package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * This element is a symbolic interface implemented by all operators used to
 * request contents (And, Or, Not, Equals, NotEquals, EndsWith, ...).
 */
public class Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected RestrictionName name;

    /**
     * Default constructor
     */
    public Restriction() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param name
     */
    public Restriction(RestrictionName name) {
        this();
        this.name = name;
    }

    /**
     * Return name
     * 
     * @return
     */
    public RestrictionName getName() {
        return name;
    }

    /**
     * Set a value to parameter name.
     * 
     * @param name
     */
    public void setName(RestrictionName name) {
        this.name = name;
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Restriction)) {
            return false;
        }

        final Restriction restrictionDto = (Restriction) other;

        if ((name == null && restrictionDto.getName() != null)
                || (name != null && !name.equals(restrictionDto.getName()))) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return Restriction.class.hashCode();
    }

}