/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.filter;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JpaTransactionFilter
implements Filter {
    public static final String JPA_TRANSACTION_REQUEST_ATTRIBUTE = "jpaTransaction";
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"close"};
    public static final String[] DEFAULT_UNUSED_METHODS = new String[]{"toString", "isOpen", "clear", "equals", "hashCode", "finalize", "getClass"};
    private static final Log log = LogFactory.getLog(JpaTransactionFilter.class);
    protected Set<String> excludeMethods;
    protected Set<String> unusedMethods;
    protected String requestAttributeName = "jpaTransaction";

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public Set<String> getUnusedMethods() {
        return this.unusedMethods;
    }

    public void setRequestAttributeName(String requestAttributeName) {
        this.requestAttributeName = requestAttributeName;
    }

    public static EntityManager getTransaction(ServletRequest request) {
        EntityManager entityManager = (EntityManager)request.getAttribute(JPA_TRANSACTION_REQUEST_ATTRIBUTE);
        return entityManager;
    }

    protected abstract EntityManager createEntityManager(ServletRequest var1);

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String methodsFromConfig = filterConfig.getInitParameter("excludeMethods");
        String[] methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_EXCLUDE_METHODS;
        this.excludeMethods = new HashSet<String>(Arrays.asList(methods));
        methodsFromConfig = filterConfig.getInitParameter("unusedMethods");
        methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_UNUSED_METHODS;
        this.unusedMethods = new HashSet<String>(Arrays.asList(methods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        JpaTransactionProxyInvocationHandler proxyInvocationHandler = new JpaTransactionProxyInvocationHandler(request);
        EntityManager proxy = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)proxyInvocationHandler);
        request.setAttribute(this.requestAttributeName, (Object)proxy);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.onCloseTransaction(proxyInvocationHandler.entityManager);
        }
    }

    protected Object onExcludeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        throw new IllegalAccessException("Not allowed to access method " + method.getName() + " on " + proxy);
    }

    protected void onCloseTransaction(EntityManager entityManager) {
        if (entityManager == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"no entityManager to close");
            }
        } else if (!entityManager.isOpen()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("entityManager " + entityManager + " is already closed"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing entityManager " + entityManager));
            }
            entityManager.close();
        }
    }

    protected Object onUnusedMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Set<String> methods;
        String methodName = method.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skip execution of method " + methodName + " since no entityManager is created"));
        }
        if ((methods = this.getUnusedMethods()).contains("toString")) {
            return "No entityManager opened yet for this proxy";
        }
        if (methods.contains("isOpen")) {
            return true;
        }
        if (methods.contains("equals")) {
            return false;
        }
        if (methods.contains("hashCode")) {
            return 0;
        }
        if (methods.contains("getClass")) {
            return EntityManager.class;
        }
        return null;
    }

    public class JpaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected final ServletRequest request;
        protected EntityManager entityManager;

        protected JpaTransactionProxyInvocationHandler(ServletRequest request) {
            this.request = request;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (JpaTransactionFilter.this.getExcludeMethods().contains(methodName)) {
                Object result = JpaTransactionFilter.this.onExcludeMethod(proxy, method, args);
                return result;
            }
            if (this.entityManager == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("entityManager started due to a call to " + methodName));
                }
                if (JpaTransactionFilter.this.getUnusedMethods().contains(methodName)) {
                    Object result = JpaTransactionFilter.this.onUnusedMethod(proxy, method, args);
                    return result;
                }
                this.entityManager = JpaTransactionFilter.this.createEntityManager(this.request);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created entityManager " + this.entityManager));
                }
            }
            try {
                Object result = method.invoke((Object)this.entityManager, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }
}

