/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityUser;

public abstract class SecurityUserAbstract
extends AbstractTopiaEntity
implements SecurityUser {
    protected String login;
    protected String password;
    protected String externalId;
    protected Collection<SecurityRole> securityRole;
    private static final long serialVersionUID = 3631647531095843635L;

    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "externalId", String.class, (Object)this.externalId);
        visitor.visit((TopiaEntity)this, "securityRole", Collection.class, SecurityRole.class, this.securityRole);
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getLogin() {
        String result = this.login;
        return result;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        String result = this.password;
        return result;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getExternalId() {
        String result = this.externalId;
        return result;
    }

    @Override
    public void addSecurityRole(SecurityRole securityRole) {
        if (this.securityRole == null) {
            this.securityRole = new LinkedList<SecurityRole>();
        }
        this.securityRole.add(securityRole);
    }

    @Override
    public void addAllSecurityRole(Collection<SecurityRole> securityRole) {
        if (securityRole == null) {
            return;
        }
        for (SecurityRole item : securityRole) {
            this.addSecurityRole(item);
        }
    }

    @Override
    public void setSecurityRole(Collection<SecurityRole> securityRole) {
        this.securityRole = securityRole;
    }

    @Override
    public void removeSecurityRole(SecurityRole securityRole) {
        if (this.securityRole == null || !this.securityRole.remove(securityRole)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSecurityRole() {
        if (this.securityRole == null) {
            return;
        }
        this.securityRole.clear();
    }

    @Override
    public Collection<SecurityRole> getSecurityRole() {
        return this.securityRole;
    }

    @Override
    public SecurityRole getSecurityRoleByTopiaId(String topiaId) {
        return (SecurityRole)TopiaEntityHelper.getEntityByTopiaId(this.securityRole, (String)topiaId);
    }

    @Override
    public Collection<String> getSecurityRoleTopiaIds() {
        LinkedList<String> topiaIds = new LinkedList<String>();
        Collection<SecurityRole> tmp = this.getSecurityRole();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSecurityRole() {
        if (this.securityRole == null) {
            return 0;
        }
        return this.securityRole.size();
    }

    @Override
    public boolean isSecurityRoleEmpty() {
        int size = this.sizeSecurityRole();
        return size == 0;
    }

    @Override
    public boolean isSecurityRoleNotEmpty() {
        boolean empty = this.isSecurityRoleEmpty();
        return !empty;
    }

    @Override
    public boolean containsSecurityRole(SecurityRole securityRole) {
        boolean contains = this.securityRole != null && this.securityRole.contains(securityRole);
        return contains;
    }
}

