/*
 * #%L
 * Nuiton Web :: Nuiton Security
 * $Id: RoleAction.java 265 2013-04-30 09:03:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.13/nuiton-security/src/main/java/org/nuiton/web/security/actions/RoleAction.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.web.security.actions;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityRoleImpl;

public class RoleAction extends AbstractAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(RoleAction.class);

    protected SecurityRoleDAO securityRoleDAO;

    protected SecurityRole role;

    public SecurityRole getRole() {
        if (role == null) {
            String roleId = getParameter("roleId");
            if (StringUtils.isNotBlank(roleId)) {
                try {
                    TopiaContext transaction = rootContext.beginTransaction();
                    securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                    role = securityRoleDAO.findByTopiaId(roleId);
                    transaction.closeContext();
                } catch (TopiaException ex) {
                    throw new TopiaRuntimeException(ex);
                }
            } else {
                role = new SecurityRoleImpl();
            }
        }
        return role;
    }

    public String delete() throws Exception {
        try {
            String roleId = getParameter("roleId");
            if (StringUtils.isNotBlank(roleId)) {
                TopiaContext transaction = rootContext.beginTransaction();
                securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                SecurityRole role = securityRoleDAO.findByTopiaId(roleId);
                securityRoleDAO.delete(role);
                transaction.commitTransaction();
                transaction.closeContext();
            }
            
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't delete role", ex);
            }
        }

        return SUCCESS;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();

        try {
            TopiaContext transaction = rootContext.beginTransaction();
            securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
            if (getRole().getTopiaId() == null) {
                securityRoleDAO.create(getRole());
            } else {
                securityRoleDAO.update(getRole());
            }
            transaction.commitTransaction();
            transaction.closeContext();
        } catch (Exception ex) {
            addActionError(ex.getMessage());
            result = input();
        }
        return result;
    }
}
