/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.web.security.SecurityRole;

public abstract class SecurityRoleAbstract
extends TopiaEntityAbstract
implements SecurityRole {
    protected String name;
    protected Collection<String> permissions;
    private static final long serialVersionUID = 4049127909472219447L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "permissions", Collection.class, String.class, this.permissions);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void addPermissions(String permissions) {
        this.fireOnPreWrite("permissions", null, permissions);
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissions);
        this.fireOnPostWrite("permissions", this.permissions.size(), null, permissions);
    }

    @Override
    public void addAllPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String item : permissions) {
            this.addPermissions(item);
        }
    }

    @Override
    public void setPermissions(Collection<String> permissions) {
        ArrayList<String> oldValue = this.permissions != null ? new ArrayList<String>(this.permissions) : null;
        this.fireOnPreWrite("permissions", oldValue, permissions);
        this.permissions = permissions;
        this.fireOnPostWrite("permissions", oldValue, permissions);
    }

    @Override
    public void removePermissions(String permissions) {
        this.fireOnPreWrite("permissions", permissions, null);
        if (this.permissions == null || !this.permissions.remove(permissions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("permissions", this.permissions.size() + 1, permissions, null);
    }

    @Override
    public void clearPermissions() {
        if (this.permissions == null) {
            return;
        }
        ArrayList<String> oldValue = new ArrayList<String>(this.permissions);
        this.fireOnPreWrite("permissions", oldValue, this.permissions);
        this.permissions.clear();
        this.fireOnPostWrite("permissions", oldValue, this.permissions);
    }

    @Override
    public Collection<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public int sizePermissions() {
        if (this.permissions == null) {
            return 0;
        }
        return this.permissions.size();
    }

    @Override
    public boolean isPermissionsEmpty() {
        int size = this.sizePermissions();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("permissions", this.permissions).toString();
        return result;
    }
}

