/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;

public class SecurityDAOHelper {
    protected SecurityDAOHelper() {
    }

    public static String getModelVersion() {
        return "";
    }

    public static String getModelName() {
        return "Security";
    }

    public static SecurityRoleDAO getSecurityRoleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SecurityRoleDAO result = (SecurityRoleDAO)ci.getDAO(SecurityRole.class, SecurityRoleDAO.class);
        return result;
    }

    public static SecurityUserDAO getSecurityUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SecurityUserDAO result = (SecurityUserDAO)ci.getDAO(SecurityUser.class, SecurityUserDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(entity);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        return constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        return constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SecurityEntityEnum[] values = SecurityEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SecurityEntityEnum[] values = SecurityEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : SecurityDAOHelper.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static SecurityEntityEnum[] getContracts() {
        return SecurityEntityEnum.values();
    }

    public static enum SecurityEntityEnum implements TopiaEntityEnum
    {
        SecurityRole(SecurityRole.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        SecurityUser(SecurityUser.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]);

        protected Class<? extends TopiaEntity> contract;
        protected String implementationFQN;
        protected Class<? extends TopiaEntity> implementation;
        protected String[] naturalIds;
        protected String[] notNulls;

        private SecurityEntityEnum(Class<? extends TopiaEntity> contract, String[] notNulls, String ... naturalIds) {
            this.contract = contract;
            this.notNulls = notNulls;
            this.naturalIds = naturalIds;
            this.implementationFQN = contract.getName() + "Impl";
        }

        public Class<? extends TopiaEntity> getContract() {
            return this.contract;
        }

        public String[] getNaturalIds() {
            return this.naturalIds;
        }

        public boolean isUseNaturalIds() {
            return this.naturalIds.length > 0;
        }

        public String[] getNotNulls() {
            return this.notNulls;
        }

        public boolean isUseNotNulls() {
            return this.notNulls.length > 0;
        }

        public String getImplementationFQN() {
            return this.implementationFQN;
        }

        public void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        public boolean accept(Class<? extends TopiaEntity> klass) {
            return SecurityDAOHelper.getContractClass(klass) == this.contract;
        }

        public Class<? extends TopiaEntity> getImplementation() {
            if (this.implementation == null) {
                try {
                    this.implementation = Class.forName(this.implementationFQN);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaRuntimeException("could not find class " + this.implementationFQN, (Throwable)e);
                }
            }
            return this.implementation;
        }

        public static SecurityEntityEnum valueOf(TopiaEntity entity) {
            return SecurityEntityEnum.valueOf(entity.getClass());
        }

        public static SecurityEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return SecurityEntityEnum.valueOf(klass.getSimpleName());
            }
            for (SecurityEntityEnum entityEnum : SecurityEntityEnum.values()) {
                if (!entityEnum.getContract().isAssignableFrom(klass)) continue;
                return entityEnum;
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])SecurityEntityEnum.values()));
        }
    }
}

