/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class ServiceInterfaceGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(ServiceInterfaceGenerator.class);
    private static final String DAO = "dao";
    private List<String> methods = null;

    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        this.methods = new ArrayList<String>();
        if (!interfacez.hasStereotype("service")) {
            return;
        }
        this.generateInterfaceHeader(output, (ObjectModelClassifier)interfacez);
        this.generateInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        this.generateInheritedInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        this.generateMethodsGetter(output, (ObjectModelClassifier)interfacez);
        this.generateAssociatedClassOperations(output, (ObjectModelClassifier)interfacez);
        output.write("\n");
        output.write("    // methodes du service\n");
        output.write("    public String[] methods = {\n");
        output.write("");
        String comma = " ";
        for (String method : this.methods) {
            output.write("        " + comma + "\"" + method + "\"\n");
            output.write("");
            comma = ", ";
        }
        output.write("    };\n");
        output.write("\t\t \n");
        output.write("} //" + interfacez.getName() + "\n");
        output.write("");
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright((Model)this.model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + classifier.getPackageName() + ";\n");
        output.write("\n");
        output.write("import java.util.List;\n");
        output.write("import java.util.Collection;\n");
        output.write("import org.nuiton.topia.TopiaException;\n");
        output.write("import org.nuiton.topia.service.TopiaApplicationService;\n");
        output.write("\n");
        output.write("");
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)classifier)) {
            String documentation = classifier.getDocumentation();
            output.write("\n");
            output.write("/**\n");
            output.write(" * " + documentation + "\n");
            output.write(" */\n");
            output.write("");
        }
        output.write("public interface " + classifierName + " extends ");
        String extendClass = "";
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            if (parent.hasStereotype(DAO)) continue;
            extendClass = extendClass + parent.getQualifiedName();
            extendClass = extendClass + ", ";
        }
        if (classifier instanceof ObjectModelClass) {
            ObjectModelClass clazz = (ObjectModelClass)classifier;
            for (ObjectModelClass parent : clazz.getSuperclasses()) {
                if (parent.hasStereotype("service")) {
                    extendClass = extendClass + parent.getQualifiedName();
                }
                extendClass = extendClass + ", ";
            }
        }
        output.write("" + extendClass + "TopiaApplicationService {\n");
        output.write("");
    }

    private void generateMethodsGetter(Writer output, ObjectModelClassifier classifier) throws IOException {
        output.write("\n");
        output.write("    public abstract String[] getMethods();\n");
        output.write("\n");
        output.write("\t// methodes utilisant celles des entites\n");
        output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            String method = opType + " " + opName + "(";
            output.write("\n");
            output.write("    /** \n");
            output.write("     * Methode " + opName + ".\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                if (!TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)param)) continue;
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write("");
            }
            output.write("     */\n");
            output.write("    " + opVisibility + " " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                method = method + comma + paramType + " " + paramName;
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("");
            this.methods.add(method + ")");
        }
    }

    private void generateInheritedInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        output.write("\n");
        output.write("\t// methodes utilisant celles des daos\n");
        output.write("");
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            if (!parent.hasStereotype(DAO)) continue;
            String entityClassName = null;
            entityClassName = parent.getQualifiedName().replace("DAO", "");
            if (!((ObjectModel)this.getModel()).hasClass(entityClassName)) continue;
            ObjectModelClass clazz = ((ObjectModel)this.getModel()).getClass(entityClassName);
            String clazzName = clazz.getName();
            String clazzFQN = clazz.getQualifiedName();
            if (!clazz.hasStereotype("entity")) {
                return;
            }
            this.methods.add("void delete" + clazzName + "(" + clazzName + " entity)");
            this.methods.add(clazzName + " create" + clazzName + "(Object ... properties)");
            this.methods.add(clazzName + " update" + clazzName + "(" + clazzName + ")");
            this.methods.add("List<" + clazzName + "> findAll" + clazzName + "()");
            this.methods.add(clazzName + " find" + clazzName + "ByTopiaId(String v)");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Supprime l'entite " + clazzName + " passee en parametre\n");
            output.write("     * @param entity l'entite a supprimer\n");
            output.write("     */\n");
            output.write("\tpublic abstract void delete" + clazzName + "(" + clazzFQN + " entity) throws TopiaException;\n");
            output.write("\t\n");
            output.write("    /**\n");
            output.write("     * Creer l'entite " + clazzName + " avec les proprietes passees en parametre\n");
            output.write("     * @param entity l'entite a mettre a jour\n");
            output.write("     */\n");
            output.write("    public abstract " + clazzFQN + " create" + clazzName + "(Object ... properties) throws TopiaException;\n");
            output.write("    \n");
            output.write("    /**\n");
            output.write("     * Mise a jour de l'entite " + clazzName + " passee en parametre\n");
            output.write("     * @param properties les proprietes de l'entite a creer\n");
            output.write("     */\n");
            output.write("    public abstract " + clazzFQN + " update" + clazzName + "(" + clazzFQN + " entity) throws TopiaException;\n");
            output.write("    \n");
            output.write("\t/**\n");
            output.write("     * Retourne tous les " + clazzName + " \n");
            output.write("     * @return une liste\n");
            output.write("     */\n");
            output.write("    public abstract List<" + clazzFQN + "> findAll" + clazzName + "() throws TopiaException;\n");
            output.write("    \n");
            output.write("    /**\n");
            output.write("     * Retourne le " + clazzName + " par son TopiaId \n");
            output.write("     * @return le " + clazzName + "\n");
            output.write("     */\n");
            output.write("    public abstract " + clazzFQN + " find" + clazzName + "ByTopiaId(String v) throws TopiaException;\n");
            output.write("");
            for (ObjectModelAttribute attr : clazz.getAttributes()) {
                if (!attr.isNavigable()) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(output, attr, clazz, false);
                    continue;
                }
                this.generateNMultiplicity(output, attr, clazz, false);
            }
            if (!(clazz instanceof ObjectModelAssociationClass)) continue;
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(output, attr, clazz, true);
                    continue;
                }
                this.generateNMultiplicity(output, attr, clazz, true);
            }
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
        String attrName;
        String propertyName = attrName = attr.getName();
        String attrType = attr.getType();
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + "." + propertyName;
        }
        this.methods.add(clazzName + " find" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " v)");
        this.methods.add("List<" + clazzName + "> findAll" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " v)");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Retourne le premier element trouve ayant comme valeur pour l'attribut\n");
        output.write("     * " + attrName + " le parametre\n");
        output.write("     * @param v la valeur que doit avoir " + attrName + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public abstract " + clazzFQN + " find" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " v) throws TopiaException;\n");
        output.write("    /**\n");
        output.write("     * Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut\n");
        output.write("     * " + attrName + " le param\u00eatre\n");
        output.write("     * @param v la valeur que doit avoir " + attrName + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public abstract  List<" + clazzFQN + "> findAll" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " v) throws TopiaException;\n");
        output.write("");
        if (attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            this.methods.add(clazzName + " find" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)assocClassName) + "(" + assocClassFQN + " value)");
            this.methods.add("List<" + clazzName + "> findAll" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)assocClassName) + "(" + assocClassFQN + " value)");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne le premier element trouve ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le parametre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\n");
            output.write("     * @return un element ou null\n");
            output.write("     */\n");
            output.write("    public abstract " + clazzFQN + " find" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)assocClassName) + "(" + assocClassFQN + " value) throws TopiaException;\n");
            output.write("    /**\n");
            output.write("     * Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le param\u00eatre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\n");
            output.write("     * @return une liste\n");
            output.write("     */\n");
            output.write("    public abstract List<" + clazzFQN + "> findAll" + clazzName + "By" + TopiaGeneratorUtil.capitalize((String)assocClassName) + "(" + assocClassFQN + " value) throws TopiaException;\n");
            output.write("");
        }
    }

    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        this.methods.add(clazzName + " find" + clazzName + "Contains" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " ... v)");
        this.methods.add("List<" + clazzName + "> findAll" + clazzName + "Contains" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " ... v)");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Retourne le premier element trouve dont l'attribut\n");
        output.write("     * " + attrName + " contient le parametre\n");
        output.write("     * @param v la valeur que doit contenir " + attrName + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public abstract " + clazzFQN + " find" + clazzName + "Contains" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " ... v) throws TopiaException;\n");
        output.write("    /**\n");
        output.write("     * Retourne les elements trouve dont l'attribut\n");
        output.write("     * " + attrName + " contient le parametre\n");
        output.write("     * @param v la valeur que doit contenir " + attrName + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public abstract List<" + clazzFQN + "> findAll" + clazzName + "Contains" + TopiaGeneratorUtil.capitalize((String)attrName) + "(" + attrType + " ... v) throws TopiaException;\n");
        output.write("");
    }

    private void generateAssociatedClassOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelClassifier parent : classifier.getInterfaces()) {
            if (!parent.hasStereotype(DAO)) continue;
            String entityClassName = null;
            entityClassName = parent.getQualifiedName().replace("DAO", "");
            if (!((ObjectModel)this.getModel()).hasClass(entityClassName)) continue;
            ObjectModelClass clazz = ((ObjectModel)this.getModel()).getClass(entityClassName);
            this.generateFromDAOClass(output, clazz);
        }
    }

    private void generateFromDAOClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String assocClassFQN;
            String assocAttrName;
            String attrName = attr.getName();
            String attrType = attr.getType();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType((ObjectModelAttribute)reverse, (ObjectModel)((ObjectModel)this.model))) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (!attr.hasAssociationClass()) {
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        this.methods.add("void set" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")");
                        output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " La valeur de l'attribut " + attrName + " \u00e0 positionner.\n");
                    output.write("     */\n");
                    output.write("    public abstract void set" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ") throws TopiaException;\n");
                    output.write("\n");
                    output.write("");
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        this.methods.add(attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId)");
                        output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @return La valeur de l'attribut " + attrName + ".\n");
                    output.write("     */\n");
                    output.write("    public abstract " + attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
                    output.write("\n");
                    output.write("");
                    continue;
                }
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                String assocClassName = attr.getAssociationClass().getName();
                String assocClassFQN2 = attr.getAssociationClass().getQualifiedName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName));
                }
                this.methods.add("void set" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + assocClassName + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")");
                this.methods.add(assocClassName + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId)");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " La valeur de l'attribut " + assocClassName + " \u00e0 positionner.\n");
                output.write("     */\n");
                output.write("    public abstract void set" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + assocClassFQN2 + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")  throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return La valeur de l'attribut " + assocClassName + ".\n");
                output.write("     */\n");
                output.write("    public abstract " + assocClassFQN2 + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId)  throws TopiaException;\n");
                output.write("\n");
                output.write("");
                continue;
            }
            if (!attr.hasAssociationClass()) {
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add("void add" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " L'instance de " + attrName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public abstract void add" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")  throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add("void addAll" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " Les instances de " + attrName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public abstract void addAll" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")  throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add("void set" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " La Collection de " + attrName + " \u00e0 positionner.\n");
                output.write("     */\n");
                output.write("    public abstract void set" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")  throws TopiaException;\n");
                output.write("\n");
                output.write("    /** \n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add("void remove" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " L'instance de " + attrName + " \u00e0 retirer.\n");
                output.write("     */\n");
                output.write("    public abstract void remove" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId, " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ")  throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add("void clear" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId)");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * Vide la Collection de " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public abstract void clear" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
                output.write("\n");
                output.write("");
            } else {
                String assocClassName = attr.getAssociationClass().getName();
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                String assocAttrName2 = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName2));
                }
                this.methods.add("void add" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + assocClassName + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")");
                this.methods.add("void addAll" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + assocClassName + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")");
                this.methods.add("void set" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + assocClassName + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")");
                this.methods.add("void remove" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + assocClassName + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ")");
                this.methods.add("void clear" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId)");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " L'instance de " + assocClassName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public abstract void add" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + assocClassFQN + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ") throws TopiaException;\n");
                output.write("\n");
                output.write("    /** \n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " Les instances de " + assocClassName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public abstract void addAll" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "List" : "Collection") + "<" + assocClassFQN + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ") throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " La Collection de " + assocClassName + " \u00e0 positionner.\n");
                output.write("     */\n");
                output.write("    public abstract void set" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + (attr.isOrdered() ? "List" : "Collection") + "<" + assocClassFQN + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ") throws TopiaException;\n");
                output.write("\n");
                output.write("    /** \n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " L'instance de " + assocClassName + " \u00e0 retirer.\n");
                output.write("     */\n");
                output.write("    public abstract void remove" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId, " + assocClassFQN + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ") throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * Vide la Collection de " + assocClassName + ".\n");
                output.write("     */\n");
                output.write("    public abstract void clear" + GeneratorUtil.capitalize((String)assocAttrName2) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
                output.write("\n");
                output.write("");
            }
            if (!attr.hasAssociationClass()) {
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    this.methods.add((attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> get" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId)");
                    this.methods.add("int size" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId)");
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @return La Liste de " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public abstract " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + attrType + "> get" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return Le nombre d'\u00e9l\u00e9ments de la collection " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public abstract int size" + GeneratorUtil.capitalize((String)attrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
                output.write("\n");
                output.write("");
                continue;
            }
            assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocClassName = attr.getAssociationClass().getName();
            if (log.isTraceEnabled()) {
                log.trace((Object)("assocAttrName: " + assocAttrName));
            }
            this.methods.add((attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + assocClassName + "> get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "Of" + clazzName + "(String topiaId)");
            this.methods.add(assocClassName + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attrType + " value)");
            this.methods.add("int size" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId)");
            output.write("    /**\n");
            output.write("     * @return La liste des attributs " + assocClassName + ".\n");
            output.write("     */\n");
            output.write("    public abstract " + (attr.isOrdered() ? "java.util.List" : "java.util.Collection") + "<" + assocClassFQN + "> get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return L'attribut " + assocClassName + " associ\u00e9 \u00e0 la valeur <code>value</code> de l'attribut " + attrName + ".\n");
            output.write("     */\n");
            output.write("    public abstract " + assocClassFQN + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId, " + attrType + " value) throws TopiaException;\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return Le nombre d'\u00e9l\u00e9ments de la collection " + attrName + ".\n");
            output.write("     */\n");
            output.write("    public abstract int size" + GeneratorUtil.capitalize((String)assocAttrName) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
            output.write("\n");
            output.write("");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String type = attr.getType();
                String name = attr.getName();
                this.generateAssociationAccessors(output, clazz, name, type);
                if (attr.getReverseAttribute() != null) continue;
                type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                name = attr.getDeclaringElement().getName();
                this.generateAssociationAccessors(output, clazz, name, type);
            }
        }
        this.generateInterfaceOperationsOfClass(output, (ObjectModelClassifier)clazz);
    }

    private void generateInterfaceOperationsOfClass(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String method = op.getReturnType() + " " + op.getName() + "(";
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                output.write("     * " + op.getName() + " : " + op.getDocumentation() + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Param" + param));
                }
                output.write("     * @param " + param.getName() + " " + param.getDocumentation() + "\n");
                output.write(" ");
            }
            output.write("     */\n");
            output.write("    " + op.getVisibility() + " abstract " + op.getReturnType() + " " + op.getName() + "Of" + classifier.getName() + "(String topiaId");
            if (params.size() > 0) {
                output.write(", ");
            }
            String vir = "";
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Param" + param + " vir" + vir));
                }
                method = method + vir + param.getType() + " " + param.getName();
                output.write("" + vir + "" + param.getType() + " " + param.getName() + "");
                vir = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            if (exceptions.isEmpty()) {
                output.write("throws TopiaException");
            }
            vir = " throws ";
            for (String exception : exceptions) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("exception" + exception + " vir" + vir));
                }
                output.write("" + vir + "" + exception + "");
                vir = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
            this.methods.add(method);
        }
    }

    private void generateAssociationAccessors(Writer output, ObjectModelClass clazz, String name, String type) throws IOException {
        String clazzName = clazz.getName();
        this.methods.add("=> void set" + GeneratorUtil.capitalize((String)name) + "Of" + clazzName + "(String topiaId, " + type + " value)");
        this.methods.add("=> " + type + " get" + GeneratorUtil.capitalize((String)name) + "Of" + clazzName + "(String topiaId)");
        output.write("    /**\n");
        output.write("     * @param value La valeur de l'attribut " + name + " \u00e0 positionner.\n");
        output.write("     */\n");
        output.write("    public abstract void set" + GeneratorUtil.capitalize((String)name) + "Of" + clazzName + "(String topiaId, " + type + " value) throws TopiaException;\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * @return La valeur de l'attribut " + name + ".\n");
        output.write("     */\n");
        output.write("    public abstract " + type + " get" + GeneratorUtil.capitalize((String)name) + "Of" + clazzName + "(String topiaId) throws TopiaException;\n");
        output.write("\n");
        output.write("");
    }
}

