/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;

public class TopiaSecurityCaching {
    protected int level;
    protected Map map;

    public TopiaSecurityCaching(int level) {
        this.level = level;
        this.map = Collections.synchronizedMap(new ReferenceMap(1, 1));
    }

    public TopiaSecurityCaching() {
        this(1);
    }

    public void put(Object value, Object ... keys) {
        if (keys.length != this.level) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Map current = this.map;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object key = keys[i];
            Map next = (Map)current.get(key);
            if (next == null) {
                next = Collections.synchronizedMap(new ReferenceMap(1, 1));
                current.put(key, next);
            }
            current = next;
        }
        current.put(keys[keys.length - 1], value);
    }

    public void clear(Object ... keys) {
        Map current = this.map;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object key = keys[i];
            Map next = (Map)current.get(key);
            if (next == null) {
                next = Collections.synchronizedMap(new ReferenceMap(1, 1));
                current.put(key, next);
            }
            current = next;
        }
        current.clear();
    }

    public Object get(Object ... keys) {
        if (keys.length != this.level) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Map current = this.map;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object key = keys[i];
            Map next = (Map)current.get(key);
            if (next == null) {
                return null;
            }
            current = next;
        }
        return current.get(keys[keys.length - 1]);
    }
}

