package org.nuiton.topia.security.entities.authorization;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TopiaEntityAuthorization.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TopiaEntityAuthorizationDAOAbstract<E extends TopiaEntityAuthorization> extends org.nuiton.topia.security.entities.authorization.TopiaAuthorizationDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaEntityAuthorization.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut expression
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * expression le paramètre
     * @param v la valeur que doit avoir expression
     * @return un element ou null
     */
    public E findByExpression(java.lang.String v) throws TopiaException {
        E result = findByProperty("expression", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * expression le paramètre
     * @param v la valeur que doit avoir expression
     * @return une liste
     */
    public List<E> findAllByExpression(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("expression", v);
        return result;
    }
    /**
     * Recherche sur l'attribut actions
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * actions le paramètre
     * @param v la valeur que doit avoir actions
     * @return un element ou null
     */
    public E findByActions(int v) throws TopiaException {
        E result = findByProperty("actions", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * actions le paramètre
     * @param v la valeur que doit avoir actions
     * @return une liste
     */
    public List<E> findAllByActions(int v) throws TopiaException {
        List<E> result = findAllByProperty("actions", v);
        return result;
    }
    /**
     * Recherche sur l'attribut principals
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * principals le paramètre
     * @param v la valeur que doit avoir principals
     * @return un element ou null
     */
    public E findByPrincipals(java.util.Set v) throws TopiaException {
        E result = findByProperty("principals", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * principals le paramètre
     * @param v la valeur que doit avoir principals
     * @return une liste
     */
    public List<E> findAllByPrincipals(java.util.Set v) throws TopiaException {
        List<E> result = findAllByProperty("principals", v);
        return result;
    }

} // TopiaEntityAuthorizationDAOAbstract
