/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.event.TopiaContextAdapter;
import org.nuiton.topia.event.TopiaContextEvent;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.migration.mappings.TMSVersionDAO;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class TopiaMigrationEngine
implements TopiaMigrationService {
    private static final Log log = LogFactory.getLog(TopiaMigrationEngine.class);
    protected Configuration versionConfiguration;
    protected boolean versionTableExist;
    protected Configuration legacyVersionConfiguration;
    protected boolean legacyVersionTableExist;
    protected Version dbVersion;
    protected boolean dbNotVersioned;
    protected boolean migrateOnInit;
    protected AbstractTopiaMigrationCallback callback;
    protected TopiaContextImplementor rootContext;
    protected boolean init;
    protected boolean versionDetected;
    protected boolean showSql;
    protected boolean showProgression;
    protected final TopiaContextListener contextListener;
    protected final TopiaTransactionVetoable transactionVetoable = new TopiaTransactionVetoable(){

        public void beginTransaction(TopiaTransactionEvent event) {
            TopiaContextImplementor context = (TopiaContextImplementor)event.getSource();
            context.addTopiaContextListener(TopiaMigrationEngine.this.contextListener);
        }
    };

    public TopiaMigrationEngine() {
        this.contextListener = new TopiaContextAdapter(){

            public void postCreateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postCreateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postUpdateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postUpdateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postRestoreSchema(TopiaContextEvent event) {
                block5: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"postRestoreSchema event detected, redo, schema migration");
                    }
                    if (TopiaMigrationEngine.this.migrateOnInit) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Starts Migrate from postRestoreSchema...");
                        }
                        try {
                            TopiaMigrationEngine.this.doMigrateSchema();
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block5;
                            log.error((Object)("postRestoreSchema schema migration failed for reason " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        };
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{TMSVersion.class};
    }

    public String getServiceName() {
        return "migration";
    }

    public boolean preInit(TopiaContextImplementor context) {
        this.rootContext = context;
        Properties config = context.getConfig();
        String callbackStr = this.getSafeParameter(config, "topia.service.migration.callback");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use callback            - " + callbackStr));
        }
        this.migrateOnInit = Boolean.valueOf(config.getProperty("topia.service.migration.no.migrate.on.init", "true"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate on init         - " + this.migrateOnInit));
        }
        this.showSql = Boolean.valueOf(config.getProperty("topia.service.migration.showSql", "false"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show sql                - " + this.showSql));
        }
        this.showProgression = Boolean.valueOf(config.getProperty("topia.service.migration.showProgression", "false"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show progression        - " + this.showProgression));
        }
        try {
            Class<?> clazz = Class.forName(callbackStr);
            this.callback = (AbstractTopiaMigrationCallback)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instanciate CallbackHandler [" + callbackStr + "]"), (Throwable)e);
        }
        Configuration configuration = new Configuration();
        for (Class<?> aClass : this.getPersistenceClasses()) {
            configuration.addClass(aClass);
        }
        this.versionConfiguration = this.creaHibernateConfiguration(configuration);
        this.init = true;
        context.addTopiaContextListener(this.contextListener);
        context.addTopiaTransactionVetoable(this.transactionVetoable);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] is init."));
        }
        if (this.migrateOnInit) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starts Migrate from preInit...");
                }
                this.doMigrateSchema();
            }
            catch (MigrationServiceException e) {
                throw new TopiaRuntimeException("Can't migrate schema for reason " + e.getMessage(), (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] skip migration on init as required"));
        }
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        return true;
    }

    public void doMigrateSchema() throws MigrationServiceException {
        boolean complete = this.migrateSchema();
        if (!complete) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"topia.migration.migration.incomplete"));
            }
            throw new TopiaRuntimeException(I18n._((String)"topia.migration.migration.incomplete"));
        }
    }

    @Override
    public boolean migrateSchema() throws MigrationServiceException {
        this.checkInit();
        this.detectDbVersion();
        Version version = this.callback.getApplicationVersion();
        log.info((Object)I18n._((String)"topia.migration.start.migration", (Object[])new Object[]{version.getVersion(), this.dbVersion.getVersion()}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate schema to version = " + this.dbVersion));
            log.debug((Object)("is db not versionned ?    = " + this.dbNotVersioned));
            log.debug((Object)("TMSVersion exists         = " + this.versionTableExist));
        }
        if (this.versionTableExist && this.dbVersion.equals((Object)version)) {
            log.info((Object)I18n._((String)"topia.migration.skip.migration.db.is.up.to.date"));
            return true;
        }
        if (this.versionTableExist && this.dbNotVersioned && this.migrateOnInit) {
            log.info((Object)I18n._((String)"topia.migration.skip.migration.db.is.empty"));
            this.saveApplicationVersion();
            return true;
        }
        if (this.legacyVersionTableExist && this.dbVersion.equals((Object)version)) {
            log.info((Object)I18n._((String)"topia.migration.skip.migration.db.is.up.to.date"));
            this.saveApplicationVersion();
            return true;
        }
        TreeSet<Version> allVersions = new TreeSet<Version>((Comparator<Version>)new VersionUtil.VersionComparator());
        allVersions.addAll(Arrays.asList(this.callback.getAvailableVersions()));
        log.info((Object)I18n._((String)"topia.migration.available.versions", (Object[])new Object[]{allVersions}));
        boolean needToMigrate = false;
        if (this.dbVersion.before(version)) {
            List versionsToApply = VersionUtil.filterVersions(allVersions, (Version)this.dbVersion, (Version)version, (boolean)false, (boolean)true);
            if (versionsToApply.isEmpty()) {
                log.info((Object)I18n._((String)"topia.migration.skip.migration.no.version.to.apply"));
            } else {
                log.info((Object)I18n._((String)"topia.migration.migrate.versions", (Object[])new Object[]{versionsToApply}));
                needToMigrate = this.callback.doMigration((TopiaContext)this.rootContext, this.dbVersion, this.showSql, this.showProgression, versionsToApply);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handler choose : " + needToMigrate));
                }
                if (!needToMigrate) {
                    return false;
                }
            }
        }
        if (!this.versionTableExist || needToMigrate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set application version in database to " + version));
            }
            this.saveApplicationVersion();
        }
        return true;
    }

    protected void saveApplicationVersion() {
        this.checkInit();
        Version version = this.callback.getApplicationVersion();
        this.detectDbVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save version     = " + version));
            log.debug((Object)("table exists     = " + this.versionTableExist));
            log.debug((Object)("Detected version = " + this.dbVersion));
        }
        try {
            boolean createTable;
            boolean bl = createTable = !this.versionTableExist;
            if (createTable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding tms_version table");
                }
                TMSVersionDAO.createTable(this.versionConfiguration);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table for " + TMSVersion.class.getSimpleName() + " created"));
                }
            }
            TopiaContext tx = this.rootContext.beginTransaction();
            try {
                TMSVersionDAO.deleteAll(tx);
                log.info((Object)I18n._((String)"topia.migration.saving.db.version", (Object[])new Object[]{version}));
                TMSVersion tmsVersion = TMSVersionDAO.create(tx, version.getVersion());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created version : " + tmsVersion.getVersion()));
                }
                tx.commitTransaction();
            }
            catch (TopiaException e) {
                if (tx != null) {
                    tx.rollbackTransaction();
                }
                throw e;
            }
            finally {
                if (tx != null) {
                    tx.closeContext();
                }
            }
            if (this.legacyVersionTableExist) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will drop legacy tmsVersion table");
                }
                TMSVersionDAO.dropTable(this.legacyVersionConfiguration);
            }
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException((Throwable)e);
        }
        this.versionTableExist = true;
        this.dbVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectDbVersion() {
        Version v;
        block15: {
            block13: {
                block11: {
                    block14: {
                        block12: {
                            if (this.versionDetected) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("version was already detected : " + this.dbVersion));
                                }
                                return;
                            }
                            v = null;
                            try {
                                this.versionTableExist = TopiaUtil.isSchemaExist((Configuration)this.versionConfiguration, (String)TMSVersion.class.getName());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Table tms_version exist = " + this.versionTableExist));
                                }
                                if (!this.versionTableExist) break block11;
                                v = this.getVersion(this.versionTableExist, "tms_version");
                                if (v != null) break block12;
                                v = Version.VZERO;
                                this.dbNotVersioned = true;
                            }
                            catch (Throwable throwable) {
                                if (v == null) {
                                    v = Version.VZERO;
                                    this.dbNotVersioned = true;
                                    log.info((Object)I18n._((String)"topia.migration.db.not.versionned"));
                                } else {
                                    log.info((Object)I18n._((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
                                }
                                this.dbVersion = v;
                                this.versionDetected = true;
                                throw throwable;
                            }
                            log.info((Object)I18n._((String)"topia.migration.db.not.versionned"));
                            break block14;
                        }
                        log.info((Object)I18n._((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
                    }
                    this.dbVersion = v;
                    this.versionDetected = true;
                    return;
                }
                Configuration conf = new Configuration();
                conf.addXML(TMSVersionDAO.LEGACY_MAPPING);
                this.legacyVersionConfiguration = this.creaHibernateConfiguration(conf);
                this.legacyVersionTableExist = TopiaUtil.isSchemaExist((Configuration)this.legacyVersionConfiguration, (String)TMSVersion.class.getName());
                if (this.legacyVersionTableExist) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Legacy : detected tmsVersion table");
                    }
                    if ((v = this.getVersion(this.legacyVersionTableExist, "tmsVersion")) != null && log.isDebugEnabled()) {
                        log.debug((Object)("Legacy : " + I18n._((String)"topia.migration.detected.db.version", (Object[])new Object[]{v})));
                    }
                }
                if (v != null) break block13;
                v = Version.VZERO;
                this.dbNotVersioned = true;
                log.info((Object)I18n._((String)"topia.migration.db.not.versionned"));
                break block15;
            }
            log.info((Object)I18n._((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
        }
        this.dbVersion = v;
        this.versionDetected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version getVersion(boolean versionTableExist, String tableName) {
        Version version;
        block7: {
            if (!versionTableExist) {
                return null;
            }
            TopiaContext tx = this.rootContext.beginTransaction();
            try {
                Version v;
                version = v = TMSVersionDAO.getVersion(tx, tableName);
                if (tx == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        tx.closeContext();
                    }
                    throw throwable;
                }
                catch (TopiaException e) {
                    throw new TopiaRuntimeException("Can't obtain dbVersion for reason " + e.getMessage(), (Throwable)e);
                }
            }
            tx.closeContext();
        }
        return version;
    }

    protected String getSafeParameter(Properties config, String key) {
        String value = config.getProperty(key, null);
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalStateException("'" + key + "' not set.");
        }
        return value;
    }

    protected void checkInit() {
        if (!this.init) {
            throw new IllegalStateException("le service n'est pas initialis\u00e9!");
        }
    }

    protected Configuration creaHibernateConfiguration(Configuration configuration) {
        Properties config = this.rootContext.getConfig();
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)configuration.getProperties());
        prop.putAll((Map<?, ?>)config);
        configuration.setProperties(prop);
        return configuration;
    }
}

