/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: ConfigurationAdapter.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/kernel/ConfigurationAdapter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.TopiaMigrationEngine;
import org.nuiton.topia.migration.common.MapAdapterAdmin;
import org.nuiton.topia.migration.common.MapAdapterImpl;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.common.ProxyClassMapped;
import org.nuiton.topia.migration.common.SimpleProxyClass;
import org.nuiton.topia.migration.common.SimpleProxyClassMapped;
import org.nuiton.util.Version;
import org.hibernate.EntityMode;
import org.hibernate.LazyInitializationException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentBag;
import org.hibernate.collection.PersistentList;
import org.hibernate.collection.PersistentSet;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.map.MapProxy;

/**
 * ConfigurationAdapter.java
 * 
 * Permet de s'abstraire d'hibernate lors de la migration des donnees.
 * Communique avec la base, pour recuperer et suaver des donnees.
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon SÃ©bastien
 * @author TrÃ¨ve Vincent
 * @deprecated since 2.3.4, please use now the simplify service {@link TopiaMigrationEngine}
 */
@Deprecated
public class ConfigurationAdapter {

    /**
     * La session factory
     */
    private SessionFactory sessionFactory;
    /**
     * La configuration hibernate
     */
    private Configuration configuration;
    /**
     * La version
     */
    private Version version;
    /**
     * Logger (common-logging)
     */
    private static Log logger = LogFactory.getLog(ConfigurationAdapter.class);
    /**
     * Helper pour le calcul des dependances
     */
    private DependenciesHelper dependenciesHelper;

    /**
     * Constructeur.
     *
     * @param configuration
     * @param version
     */
    public ConfigurationAdapter(Configuration configuration, Version version) {
        this.configuration = configuration;
        sessionFactory = configuration.buildSessionFactory();
        this.version = version;

        // sessionFactory necessaire pour le calcul, c'est moche, mais on a pas
        // le choix
        dependenciesHelper = new DependenciesHelper(sessionFactory,
                configuration);
    }

    /**
     * Accesseur au dependencies helper
     *
     * @return le dependencie helper
     */
    public DependenciesHelper getDependenciesHelper() {
        return dependenciesHelper;
    }

    /**
     * Retourne la version
     *
     * @return la version
     */
    public Version getVersion() {
        return version;
    }

    /**
     * Retourne le nom de toutes les classes definies dans cette configuration
     *
     * @return une collection de noms de table
     */
    public Collection<ProxyClass> getClasses() {
        // recupere la liste de classes dans la configuration
        Iterator<?> iClass = configuration.getClassMappings();

        // Instancie la collection
        Collection<ProxyClass> cClass = new LinkedList<ProxyClass>();
        // boucle pour chaque classe de l'iterateur
        while (iClass.hasNext()) {
            // cast
            PersistentClass rc = (PersistentClass) iClass.next();

            String name = rc.getClassName();
            if (name == null) {
                name = rc.getEntityName();
            }

            // on ajoute cette classe a la collection
            cClass.add(new SimpleProxyClass(name));
        }
        // retourne la collection des noms de classe
        return cClass;
    }

    /**
     * Retourne l'ensemble des tuples d'une map
     *
     * @param className
     *            le nom de la classe
     * @return une collection de MapAdapterAdmin, un pour chaque tuple
     */
    public Collection<MapAdapterAdmin> getData(ProxyClass className) {
        // retour
        LinkedList<MapAdapterAdmin> result = new LinkedList<MapAdapterAdmin>();

        // session
        Session session = sessionFactory.openSession();

        // transaction
        Transaction tx = session.beginTransaction();

        logger.debug("Fetching data for class : " + className.getCanonicalName());
        String nomIdAttribute = configuration.getClassMapping(
                className.getCanonicalName()).getIdentifierProperty().getName();

        // data
        Session dynamicSession = session.getSession(EntityMode.MAP);
        List<?> lstReponse = dynamicSession.createCriteria(
                className.getCanonicalName()).list();

        for (Object o : lstReponse) {
            Map<String, Object> m = (Map<String, Object>) o;
            m = removeProxyMaps(m);

            MapAdapterAdmin map = new MapAdapterImpl(m, className,
                    nomIdAttribute, (Serializable) m.get(nomIdAttribute));
            map.setInnerVersion(getVersion());
            result.add(map);
        }

        // On ferme la transaction en ne faisant pas de save
        // Lorsque l'on faisait un session.close(), il y avait toujours un
        // verrou sur la table concernée.
        tx.rollback();

        return result;
    }

    /**
     * TODO comment me
     * @param className
     * @param idVal
     * @return
     */
    public MapAdapterAdmin getData(ProxyClass className, Serializable idVal) {

        // session
        Session session = sessionFactory.openSession();

        // transaction
        Transaction tx = session.beginTransaction();

        //logger.debug("Fetching one row from class : " + className.getCanonicalName());

        String nomIdAttribute = configuration.getClassMapping(
                className.getCanonicalName()).getIdentifierProperty().getName();

        // data
        Session dynamicSession = session.getSession(EntityMode.MAP);
        Map<String, Object> m = (Map<String, Object>) dynamicSession.get(
                className.getCanonicalName(), idVal);

        MapAdapterAdmin maa = null;

        if (m != null) {

            // suppression des proxy
            m = removeProxyMaps(m);

            maa = new MapAdapterImpl(m, className, nomIdAttribute,
                    (Serializable) m.get(nomIdAttribute));
            maa.setInnerVersion(getVersion());
        }

        tx.commit();

        return maa;
    }

    /**
     * Sauve une collection de map
     *
     * @param myMaps
     *            la collection de MapAdapter
     * @param linkedClass
     * @see MapAdapterAdmin
     */
    public void saveMaps(Collection<MapAdapterAdmin> myMaps,
            Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        logger.debug("Saving collection of maps");
        for (MapAdapterAdmin maMap : myMaps) {
            saveMap(maMap, linkedClass);
        }
    }

    /**
     * Sauve une map
     *
     * @param maMap
     *            la map
     * @param linkedClass
     * @see MapAdapterAdmin
     */
    public void saveMap(MapAdapterAdmin maMap,
            Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        // pas de log ici, chaque tuple de la base passe ici

        // extraction des variables
        ProxyClass clazz = maMap.getInnerClass();

        // session
        Session session = sessionFactory.getCurrentSession();
        session.beginTransaction();
        Session dynamicSession = session.getSession(EntityMode.MAP); // mode map

        // replace datas
        Map<String, Object> mapData = removeImbricatedMaps(dynamicSession, maMap.getInnerMap(),
                linkedClass);
        deletePersistentCollection(mapData);
        modifyId(mapData, linkedClass);
        session.getTransaction().rollback(); // to disconnect id associated within session

        // session
        session = sessionFactory.getCurrentSession();
        session.beginTransaction();

        dynamicSession = session.getSession(EntityMode.MAP); // mode map
        dynamicSession.saveOrUpdate(clazz.getCanonicalName(), mapData);

        session.getTransaction().commit();
    }

    /**
     * Modifie le nom de l'attribut identifiant
     * @param mapData
     * @param linkedClass
     */
    private void modifyId(Map<String, Object> mapData,
            Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        // nom de la classe de mapping des item imbriques

        String clazz = mapData.get("$type$").toString();
        ProxyClassMapped pc = null;

        if (linkedClass != null &&
            linkedClass.containsKey(new SimpleProxyClassMapped(
                new SimpleProxyClass(clazz)))) {

            pc = linkedClass.get(new SimpleProxyClassMapped(
                    new SimpleProxyClass(clazz)));
            clazz = pc.getProxyClass().getCanonicalName();
        }

        // pour cet item, on recuperer le nom de la cle, (par exempe ID)
        String nomIdAttribute;
        if (pc != null) {
            nomIdAttribute = (String) pc.getIdAttribute();
            mapData.put(nomIdAttribute, pc.getMigrationClass().modifyId(
                    (Serializable) mapData.get(nomIdAttribute)));
            mapData.put("$type$", clazz);
        }
    }

    /**
     *
     * @param mapData
     */
    private void deletePersistentCollection(Map<String, Object> mapData) {
        Map<String, Object> m = new HashMap<String, Object>();
        for (String key : mapData.keySet()) {

            if (mapData.get(key) instanceof AbstractPersistentCollection) {

                // remove collections
                Collection<?> c = (Collection<?>) mapData.get(key);
                for (Object element : c) {
                    if (element instanceof Map<?, ?>) {
                        deletePersistentCollection((Map<String, Object>) element);
                    }
                }

                // copy current map without proxy
                if (mapData.get(key) instanceof PersistentSet) {
                    m.put(key, new HashSet<Object>(c));
                } else if (mapData.get(key) instanceof PersistentBag) {
                    m.put(key, new LinkedList<Object>(c));
                } else if (mapData.get(key) instanceof PersistentList) {
                    m.put(key, new LinkedList<Object>(c));
                } else {
                    logger.error("Unknow collection type : " + mapData.get(key));
                }
            }
        }

        // copy map for return
        for (String key : m.keySet()) {
            mapData.put(key, m.get(key));
        }
    }

    /**
     * Suprimme les proxy
     * @param map la map
     * @return la map sans proxy
     */
    private Map<String, Object> removeProxy(Map<String, Object> map) {
        Map<String, Object> result = new HashMap<String, Object>(map);
        for (String key : map.keySet()) {
            if (map.get(key) instanceof MapProxy) {
                Map<?, ?> m = deleteMapProxy((MapProxy) map.get(key));
                map.put(key, m);
            }
        }
        return result;
    }

    /**
     * Supprime les map internes etant des proxy hibernate.
     * Cas "lazy".
     *
     * @param map une map qui peut contenir des proxy
     * @return Une map sans map imbrique de type proxy
     */
    private Map<String, Object> removeProxyMaps(Map<String, Object> map) {

        // copy the map
        Map<String, Object> m = new HashMap<String, Object>(map);

        // donc, pour tous les cle de cette map ...
        for (String key : m.keySet()) {

            // ... certaines sont des maps imbriquees
            // et il faut les transformer

            // ici , une liste de maps (relation x>*)
            if (m.get(key) instanceof Iterable<?>) {
                // pour l'ensemble des items contenu dans cette map
                // (on travaille ici au premier niveau, hibernate remplacera les
                // sous
                // niveau tout seul)
                Iterable<?> pl = (Iterable<?>) m.get(key);
                for (Object element : pl) {
                    // item courant de la map
                    if (element instanceof Map<?, ?>) {
                        element = removeProxy((Map<String, Object>) element);
                    }
                }
            } // sinon, une seule map
            else if (m.get(key) instanceof Map<?, ?>) {
                map.put(key, removeProxy((Map<String, Object>) m.get(key)));
            }
            /*
             * else { logger.debug(" type attribut " +
             * m.get(key).getClass().getName()); }
             */
        }

        return map;
    }

    /**
     * Supprime les map etant des proxy hibernate
     *
     * @param element
     * @return une map sans proxy
     */
    private Map<String, Object> deleteMapProxy(MapProxy element) {

        Map<String, Object> result = new HashMap<String, Object>();
        if (element instanceof MapProxy) {
            // logger.debug("Avant : " + element);
            MapProxy mp = (MapProxy) element;
            result.putAll(mp);
            // logger.debug("Apres : " + result);
        }
        return result;
    }

    private Map<String, Object> convertToNewMap(Map<String, Object> element, Session dynamicSession,
            Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {

        // nom de la classe de mapping des item imbriques
        String clazz = element.get("$type$").toString();
        ProxyClassMapped pc = null;

        if (linkedClass != null &&
            linkedClass.containsKey(new SimpleProxyClassMapped(
                new SimpleProxyClass(clazz)))) {
            pc = linkedClass.get(new SimpleProxyClassMapped(
                    new SimpleProxyClass(clazz)));
            clazz = pc.getProxyClass().getCanonicalName();
        }
        // pour cet item, on recuperer le nom de la cle, (par exempe ID)
        String nomIdAttribute;
        if (pc != null) {
            nomIdAttribute = (String) pc.getIdAttribute();
        } else {
            nomIdAttribute = configuration.getClassMapping(clazz).getIdentifierProperty().getName();
        }

        // Valeur de la cle
        Object idElement = element.get(nomIdAttribute);
        if (pc != null) {
            idElement = pc.getMigrationClass().modifyId(
                    (Serializable) idElement);
        }

        /* Recuperation de la map */
        Map<String, Object> newMap = null;

        //logger.debug("try to get map for '" + clazz + "' id="+idElement.toString());

        try {
            newMap = (Map<String, Object>) dynamicSession.get(clazz, (Serializable) idElement);
        } catch (LazyInitializationException e) {
            // cette exception est bizarement levee
            // dans le cas des relations *-* a double visibilite
            // si une classe est migrer en premier, ses
            // map internes ne peuvent pas etre initialise
            // depuis la nouvelle base (elles n'ont pas encore ete traitees)
            newMap = null;
        }

        if (newMap != null) {
            // ca va supprimer l'item courant et le remplacer par l'ancien
            element.clear();
            removeProxy(newMap);
            element.putAll(newMap);
        } else {
            logger.debug("No map found for specified identifier in new database, skip");
        }

        return newMap;
    }

    /**
     * Retire les map interne anciennes, et les remplace par les map de la
     * nouvelle base.
     *
     * @param dynamicSession la session en mode "entitymap"
     * @param map la map
     * @param linkedClass
     * @return la nouvelle map
     */
    private Map<String, Object> removeImbricatedMaps(Session dynamicSession,
            Map<String, Object> map,
            Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {

        // session
        //Session session = this.sessionFactory.getCurrentSession();
        //session.beginTransaction();

        // mode map
        //Session dynamicSession = session.getSession(EntityMode.MAP);

        // copy the map
        Map<String, Object> m = new HashMap<String, Object>(map);

        // donc, pour tous les cle de cette map ...
        for (String key : m.keySet()) {

            // ... certaines sont des maps imbriquees
            // et il faut les transformer

            // ici , une liste de maps (relation x>*)
            if (m.get(key) instanceof Iterable<?>) {
                // logger.debug(" type attribut Iterable " +
                // m.get(key).getClass().getName());
                // pour l'ensemble des items contenu dans cette map
                // (on travaille ici au premier niveau, hibernate remplacera les
                // sous
                // niveau tout seul)

                Iterable<?> pl = (Iterable<?>) m.get(key);
                for (Iterator<?> iter = pl.iterator(); iter.hasNext();) {

                    // item courant de la map
                    Map<String, Object> element = (Map<String, Object>) iter.next();
                    element = convertToNewMap(element, dynamicSession,
                            linkedClass);
                }
            } // sinon, une seule map
            else if (m.get(key) instanceof Map<?, ?>) {
                // logger.debug(" type attribut map");
                Map<String, Object> element = (Map<String, Object>) m.get(key);
                element = convertToNewMap(element, dynamicSession, linkedClass);
                // remplace la map
                map.put(key, element);
            }
        }

        // On fait un rollback car on a aucun save
        //session.getTransaction().rollback();

        return map;
    }

    /**
     * Retourne le nom de l'attribut identifiant d'une classe en lisant la confuguration.
     *
     * @param pc le nom de la classe
     * @return le nom de l'identifiant
     */
    public String getNameIdAttribute(ProxyClass pc) {
        return configuration.getClassMapping(pc.getCanonicalName()).getIdentifierProperty().getName();
    }
}
