/* *##% ToPIA - Migration service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.topia.migration.transformation;

import java.io.Serializable;

import org.nuiton.topia.migration.common.MapAdapter;
import org.nuiton.topia.migration.common.ProxyClass;

/**
 * AbstractMigration.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public abstract class AbstractMigration implements Migration {

    /**
     * Modification de l'identifiant
     * @param value L'ancienne valeur de l'identifiant
     * @return La nouvelle valeur de l'identifiant
     */
    @Override
    public Serializable modifyId(Serializable value) {
        return value;
    }

    /**
     * Nom de la classe depuis laquelle provient la nouvelle classe
     * @return Le nom de la classe depuis laquelle provient la nouvelle classe ou <tt>null</tt> si le nom ne change pas
     */
    @Override
    public ProxyClass migrateFrom() {
        return null;
    }

    /**
     * Effectue la migration
     * @param map La map d'entree/sortie
     * @param helper Le helper permettant d'acceder au autre tuple de la base
     */
    @Override
    public abstract void migrate(MapAdapter map, MapHelper helper);
}
