/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaConfigurationBuilder;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.internal.FullyQualifiedNamePlusUuidTopiaIdFactory;
import org.nuiton.topia.persistence.jdbc.BeanJdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;

public class BeanTopiaConfiguration
extends BeanJdbcConfiguration
implements TopiaConfiguration {
    protected String schemaName;
    protected Map<String, String> hibernateExtraConfiguration = new LinkedHashMap<String, String>();
    protected boolean initSchema = true;
    protected boolean validateSchema = true;
    protected Map<String, Class<? extends TopiaService>> declaredServices = new LinkedHashMap<String, Class<? extends TopiaService>>();
    protected Map<String, Map<String, String>> declaredServicesConfiguration = new LinkedHashMap<String, Map<String, String>>();
    protected TopiaIdFactory topiaIdFactory = new FullyQualifiedNamePlusUuidTopiaIdFactory();

    public BeanTopiaConfiguration() {
    }

    public BeanTopiaConfiguration(JdbcConfiguration jdbcConfiguration) {
        this.setJdbcConnectionUrl(jdbcConfiguration.getJdbcConnectionUrl());
        this.setJdbcConnectionUser(jdbcConfiguration.getJdbcConnectionUser());
        this.setJdbcConnectionPassword(jdbcConfiguration.getJdbcConnectionPassword());
        this.setJdbcDriverClass(jdbcConfiguration.getJdbcDriverClass());
    }

    @Override
    public TopiaIdFactory getTopiaIdFactory() {
        return this.topiaIdFactory;
    }

    public void setTopiaIdFactory(TopiaIdFactory topiaIdFactory) {
        this.topiaIdFactory = topiaIdFactory;
    }

    public void setTopiaIdFactoryClassName(String topiaIdFactoryClassName) {
        try {
            Class<?> topiaIdFactoryClass = Class.forName(topiaIdFactoryClassName);
            if (!TopiaIdFactory.class.isAssignableFrom(topiaIdFactoryClass)) {
                throw new IllegalArgumentException(topiaIdFactoryClassName + " seems not to be a TopiaIdFactory: it does not implement " + TopiaIdFactory.class.getName());
            }
            this.setTopiaIdFactoryClass(topiaIdFactoryClass);
        }
        catch (ClassNotFoundException e) {
            throw new TopiaMisconfigurationException(topiaIdFactoryClassName + " cannot be found", this);
        }
    }

    public void setTopiaIdFactoryClass(Class<? extends TopiaIdFactory> topiaIdFactoryClass) {
        try {
            this.setTopiaIdFactory(topiaIdFactoryClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new TopiaMisconfigurationException(topiaIdFactoryClass + " is not instantiable", this);
        }
        catch (IllegalAccessException e) {
            throw new TopiaMisconfigurationException(topiaIdFactoryClass + " is not instantiable", this);
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public Map<String, String> getHibernateExtraConfiguration() {
        return this.hibernateExtraConfiguration;
    }

    public void setHibernateExtraConfiguration(Map<String, String> hibernateExtraConfiguration) {
        this.hibernateExtraConfiguration = hibernateExtraConfiguration;
    }

    @Override
    public boolean isInitSchema() {
        return this.initSchema;
    }

    public void setInitSchema(boolean initSchema) {
        this.initSchema = initSchema;
    }

    @Override
    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    @Override
    public Map<String, Class<? extends TopiaService>> getDeclaredServices() {
        return this.declaredServices;
    }

    public void setDeclaredServices(Map<String, Class<? extends TopiaService>> declaredServices) {
        this.declaredServices = declaredServices;
    }

    @Override
    public Map<String, Map<String, String>> getDeclaredServicesConfiguration() {
        return this.declaredServicesConfiguration;
    }

    public void setDeclaredServicesConfiguration(Map<String, Map<String, String>> declaredServicesConfiguration) {
        this.declaredServicesConfiguration = declaredServicesConfiguration;
    }

    public void addDeclaredService(String serviceName, String serviceClassName, Map<String, String> serviceConfiguration) {
        try {
            Class<?> aClass;
            Class<?> serviceClass = aClass = Class.forName(serviceClassName);
            this.addDeclaredService(serviceName, serviceClass, serviceConfiguration);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(serviceClassName + " cannot be found in classpath");
        }
    }

    public void addDeclaredService(String serviceName, String serviceClassName) {
        this.addDeclaredService(serviceName, serviceClassName, Collections.emptyMap());
    }

    public void addDeclaredService(String serviceName, Class<? extends TopiaService> serviceClassName, Map<String, String> serviceConfiguration) {
        this.declaredServices.put(serviceName, serviceClassName);
        this.declaredServicesConfiguration.put(serviceName, serviceConfiguration);
    }

    public void addDeclaredService(String serviceName, Class<? extends TopiaService> serviceClassName) {
        this.addDeclaredService(serviceName, serviceClassName, Collections.emptyMap());
    }

    @Override
    public String dangerousToString() {
        return new TopiaConfigurationBuilder().toMap(this).toString();
    }

    @Override
    public String toString() {
        String safeToString = StringUtils.replace((String)this.dangerousToString(), (String)this.getJdbcConnectionPassword(), (String)"***** hidden by BeanTopiaConfiguration#toString *****");
        return safeToString;
    }
}

