/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Objects;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;

public abstract class AbstractTopiaEntity
implements TopiaEntity {
    private static final long serialVersionUID = -7458577454878852241L;
    protected static final TopiaFiresSupport DEFAULT_INSTANCE = new TopiaFiresSupport();
    protected String topiaId;
    protected long topiaVersion;
    protected Date topiaCreateDate = new Date();
    protected transient boolean deleted;
    protected transient WeakReference<TopiaFiresSupport> firesSupport;
    protected transient PropertyChangeSupport readListeners;
    protected transient PropertyChangeSupport writeListeners;
    protected transient VetoableChangeSupport readVetoables;
    protected transient VetoableChangeSupport writeVetoables;

    public void setFiresSupport(TopiaFiresSupport firesSupport) {
        this.firesSupport = new WeakReference<TopiaFiresSupport>(firesSupport);
    }

    protected TopiaFiresSupport getFiresSupportOrNull() {
        TopiaEntityContextable contextable;
        AbstractTopiaDao entityDao;
        TopiaFiresSupport result;
        TopiaFiresSupport topiaFiresSupport = result = this.firesSupport == null ? null : (TopiaFiresSupport)this.firesSupport.get();
        if (result == null && this instanceof TopiaEntityContextable && (entityDao = (AbstractTopiaDao)(contextable = (TopiaEntityContextable)((Object)this)).getGenericEntityDao()) != null) {
            result = entityDao.getTopiaFiresSupport();
            this.setFiresSupport(result);
        }
        return result;
    }

    protected TopiaFiresSupport getFiresSupport() {
        TopiaFiresSupport result = (TopiaFiresSupport)Objects.firstNonNull((Object)this.getFiresSupportOrNull(), (Object)DEFAULT_INSTANCE);
        return result;
    }

    protected PropertyChangeSupport getReadPropertyChangeSupport(boolean create) {
        if (this.readListeners == null && create) {
            this.readListeners = new PropertyChangeSupport(this);
        }
        return this.readListeners;
    }

    protected PropertyChangeSupport getWritePropertyChangeSupport(boolean create) {
        if (this.writeListeners == null && create) {
            this.writeListeners = new PropertyChangeSupport(this);
        }
        return this.writeListeners;
    }

    protected VetoableChangeSupport getReadVetoableChangeSupport(boolean create) {
        if (this.readVetoables == null && create) {
            this.readVetoables = new VetoableChangeSupport(this);
        }
        return this.readVetoables;
    }

    protected VetoableChangeSupport getWriteVetoableChangeSupport(boolean create) {
        if (this.writeVetoables == null && create) {
            this.writeVetoables = new VetoableChangeSupport(this);
        }
        return this.writeVetoables;
    }

    @Override
    public String getTopiaId() {
        return this.topiaId;
    }

    @Override
    public void setTopiaId(String v) {
        this.topiaId = v;
    }

    @Override
    public long getTopiaVersion() {
        return this.topiaVersion;
    }

    @Override
    public void setTopiaVersion(long v) {
        this.topiaVersion = v;
    }

    @Override
    public Date getTopiaCreateDate() {
        return this.topiaCreateDate;
    }

    @Override
    public void setTopiaCreateDate(Date topiaCreateDate) {
        this.topiaCreateDate = topiaCreateDate;
    }

    @Override
    public boolean isPersisted() {
        boolean result = this.topiaId != null;
        return result &= !this.deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void notifyDeleted() {
        this.deleted = true;
    }

    public int hashCode() {
        Date date = this.getTopiaCreateDate();
        int result = date == null ? 0 : date.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopiaEntity)) {
            return false;
        }
        TopiaEntity other = (TopiaEntity)obj;
        if (this.getTopiaId() == null || other.getTopiaId() == null) {
            return false;
        }
        boolean result = this.getTopiaId().equals(other.getTopiaId());
        return result;
    }

    protected void fireOnPreRead(String propertyName, Object value) {
        VetoableChangeSupport vetoableChangeSupport = this.getReadVetoableChangeSupport(false);
        if (vetoableChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPreRead(vetoableChangeSupport, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, Object value) {
        PropertyChangeSupport propertyChangeSupport = this.getReadPropertyChangeSupport(false);
        if (propertyChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostRead(propertyChangeSupport, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, int index, Object value) {
        PropertyChangeSupport propertyChangeSupport = this.getReadPropertyChangeSupport(false);
        if (propertyChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostRead(propertyChangeSupport, this, propertyName, index, value);
        }
    }

    protected void fireOnPreWrite(String propertyName, Object oldValue, Object newValue) {
        VetoableChangeSupport vetoableChangeSupport = this.getWriteVetoableChangeSupport(false);
        if (vetoableChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPreWrite(vetoableChangeSupport, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport propertyChangeSupport = this.getWritePropertyChangeSupport(false);
        if (propertyChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostWrite(propertyChangeSupport, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, int index, Object oldValue, Object newValue) {
        PropertyChangeSupport propertyChangeSupport = this.getWritePropertyChangeSupport(false);
        if (propertyChangeSupport != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostWrite(propertyChangeSupport, this, propertyName, index, oldValue, newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport(true).addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport(true).addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport(true).addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport(true).addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport(true).removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getWritePropertyChangeSupport(true).removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport(true).removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoable) {
        this.getWriteVetoableChangeSupport(true).removeVetoableChangeListener(vetoable);
    }

    @Override
    public void addPropertyListener(String propertyName, PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport(true).addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport(true).addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport(true).addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableListener(VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport(true).addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyListener(String propertyName, PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport(true).removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener listener) {
        this.getReadPropertyChangeSupport(true).removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport(true).removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableListener(VetoableChangeListener vetoable) {
        this.getReadVetoableChangeSupport(true).removeVetoableChangeListener(vetoable);
    }
}

