/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class TopiaSqlQuery<O> {
    protected abstract PreparedStatement prepareQuery(Connection var1) throws SQLException;

    protected abstract O prepareResult(ResultSet var1) throws SQLException;

    protected void afterExecuteQuery(ResultSet set) throws SQLException {
    }

    protected String[] getColumnNames(ResultSet set) throws SQLException {
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] result = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = metaData.getColumnName(i + 1);
        }
        return result;
    }

    protected long getNbRows(ResultSet set) throws SQLException {
        long nbRows = 0L;
        while (set.next()) {
            ++nbRows;
        }
        set.beforeFirst();
        return nbRows;
    }

    protected Map<String, Object> getRowAsMap(String[] columnNames, ResultSet set) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            String name = columnNames[i];
            Object value = set.getObject(i + 1);
            result.put(name, value);
        }
        return result;
    }
}

