package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: HqlAndParametersBuilderTest.java 2872 2013-11-15 09:51:40Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/test/java/org/nuiton/topia/persistence/HqlAndParametersBuilderTest.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

import java.util.Collection;

public class HqlAndParametersBuilderTest {

    protected HqlAndParametersBuilder hqlAndParametersBuilder =
            new HqlAndParametersBuilder(TopiaEntity.class);

    protected static final Collection<String> SOME_VALUES =
            Lists.newArrayList("value1", "value2", "value3");

    protected static final Collection<String> SOME_VALUES_WITH_NULL =
            Lists.newArrayList("value1", "value2", null, "value3");

    @Test
    public void testFindAvailableHqlParameterName() {

        String availableHqlParameterName1 = hqlAndParametersBuilder.putHqlParameterWithAvailableName("survey.topiaId", "topiaId1");
        String availableHqlParameterName2 = hqlAndParametersBuilder.putHqlParameterWithAvailableName("survey.topiaId", "topiaId1");

        Assert.assertNotEquals(availableHqlParameterName1, availableHqlParameterName2);
        Assert.assertFalse(availableHqlParameterName1.contains("."));
        Assert.assertFalse(availableHqlParameterName2.contains("."));

    }

    @Test
    public void testEqualsNull() {

        hqlAndParametersBuilder.addEquals("myProp", null);

        String actualHql = hqlAndParametersBuilder.getHql();

        Assert.assertFalse(actualHql.contains("myProp = null"));
        Assert.assertTrue(actualHql.contains("myProp is null"));

    }

    @Test
    public void testAddInWithNull() {

        hqlAndParametersBuilder.addIn("myProp", SOME_VALUES_WITH_NULL);

        String actualHql = hqlAndParametersBuilder.getHql();

        Assert.assertTrue(actualHql.contains("myProp is null or topiaEntity_.myProp in ("));
        Assert.assertEquals(
                SOME_VALUES_WITH_NULL.size() - 1, // there should be as many argument as in collection minus 1 because null is removed
                hqlAndParametersBuilder.getHqlParameters().size());

    }

    @Test
    public void testAddNotEqualsToValue() {

        hqlAndParametersBuilder.addNotEquals("myProp", "value");

        String actualHql = hqlAndParametersBuilder.getHql();

        Assert.assertTrue(actualHql.contains("myProp != "));
        Assert.assertFalse(actualHql.contains("myProp = "));

    }

    @Test
    public void testAddNotEqualsToNull() {

        hqlAndParametersBuilder.addNotEquals("myProp", null);

        String actualHql = hqlAndParametersBuilder.getHql();

        Assert.assertTrue(actualHql.contains("myProp is not null"));

    }

    @Test
    public void testAddNotInWithNull() {

        hqlAndParametersBuilder.addNotIn("myProp", SOME_VALUES_WITH_NULL);

        String actualHql = hqlAndParametersBuilder.getHql();

        Assert.assertTrue(actualHql.contains("myProp is not null and "));

    }

}
