/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.io.File;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaReplicationDestination;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetDAO;

public class TopiaContextReplicateTest {
    @Rule
    public final TopiaDatabase dbSource = new TopiaDatabase(){

        @Override
        protected void onDbConfigurationCreate(Properties configuration, File testDir, String dbPath) {
            configuration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath + "-source");
        }
    };
    @Rule
    public final TopiaDatabase dbTarget = new TopiaDatabase(){

        @Override
        protected void onDbConfigurationCreate(Properties configuration, File testDir, String dbPath) {
            configuration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath + "-target");
        }
    };

    @Test
    public void replicateEntity() throws Exception {
        TopiaTestTopiaPersistenceContext txSource = this.dbSource.beginTransaction();
        PersonDAO daoSource = TopiaTestDAOHelper.getPersonDAO((TopiaDaoSupplier)txSource);
        PetDAO petDAOSource = TopiaTestDAOHelper.getPetDAO((TopiaDaoSupplier)txSource);
        Person personSource = (Person)daoSource.create("firstname", " firstName", new Object[]{"name", " name"});
        Pet petSource = (Pet)petDAOSource.create("name", "name", new Object[]{"type", "type", "person", personSource});
        personSource.addPet(petSource);
        txSource.commitTransaction();
        daoSource = TopiaTestDAOHelper.getPersonDAO((TopiaDaoSupplier)txSource);
        personSource = (Person)daoSource.findByTopiaId(personSource.getTopiaId());
        Assert.assertNotNull((Object)personSource);
        petSource = (Pet)petDAOSource.findByTopiaId(petSource.getTopiaId());
        Assert.assertNotNull((Object)petSource);
        Assert.assertEquals((long)1L, (long)personSource.sizePet());
        Assert.assertEquals((Object)petSource, (Object)personSource.getPet().iterator().next());
        TopiaTestTopiaPersistenceContext txTarget = this.dbTarget.beginTransaction();
        txSource.replicateEntity((TopiaReplicationDestination)txTarget, petSource);
        txSource.replicateEntity((TopiaReplicationDestination)txTarget, personSource);
        txTarget.commitTransaction();
        PersonDAO daoTarget = TopiaTestDAOHelper.getPersonDAO((TopiaDaoSupplier)txTarget);
        PetDAO petDAOTarget = TopiaTestDAOHelper.getPetDAO((TopiaDaoSupplier)txTarget);
        Person personTarget = (Person)daoTarget.findByTopiaId(personSource.getTopiaId());
        Assert.assertNotNull((Object)personTarget);
        Assert.assertEquals((Object)personSource, (Object)personTarget);
        Assert.assertEquals((long)1L, (long)personTarget.sizePet());
        Pet petTarget = (Pet)petDAOTarget.findByTopiaId(petSource.getTopiaId());
        Assert.assertNotNull((Object)petTarget);
        Assert.assertEquals((Object)petSource, (Object)petTarget);
        Assert.assertEquals((Object)petTarget, (Object)personTarget.getPet().iterator().next());
    }
}

