/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.io.File;
import java.util.Locale;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

public class TopiaConnectionProviderTest {
    public static final String TEST_URL = "testURL";
    @Rule
    public final TopiaDatabase db = new TopiaDatabase("/TopiaConnectionProviderHardcoded.properties"){

        @Override
        protected void onDbConfigurationCreate(Properties configuration, File testdir, String dbPath) {
            Assert.assertFalse((boolean)testdir.exists());
            String dbPathFake = new File(testdir, "fake" + File.separator + "db").getAbsolutePath();
            Assert.assertFalse((boolean)new File(dbPathFake).getParentFile().exists());
            configuration.setProperty("dbPath", dbPath);
            configuration.setProperty("dbPathFake", dbPathFake);
            configuration.setProperty(TopiaConnectionProviderTest.TEST_URL, "jdbc:h2:file:" + dbPath);
            configuration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPathFake);
        }
    };

    @Test
    public void testWithHardcoded() throws Exception {
        String dbPath = (String)this.db.getDbConfiguration().get("dbPath");
        String dbPathFake = (String)this.db.getDbConfiguration().get("dbPathFake");
        Locale.setDefault(Locale.FRANCE);
        this.doStuffOnDb();
        Assert.assertTrue((boolean)new File(dbPath).getParentFile().exists());
        Assert.assertFalse((boolean)new File(dbPathFake).getParentFile().exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStuffOnDb() throws TopiaException {
        TopiaTestTopiaPersistenceContext transaction = this.db.beginTransaction();
        try {
            PersonDAO dao = TopiaTestDAOHelper.getPersonDAO((TopiaDaoSupplier)transaction);
            Person personne = (Person)dao.create("name", "Jack Bauer", new Object[0]);
            transaction.commitTransaction();
            String idPersonne = personne.getTopiaId();
            Assert.assertNotNull((Object)idPersonne);
            transaction.commitTransaction();
        }
        finally {
            transaction.closeContext();
        }
    }
}

