/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.jdbc.Work;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaEntitiesVetoable;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaSchemaListener;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.persistence.DefaultTopiaIdFactory;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class AbstractTopiaContext
implements TopiaContext,
TopiaContextImplementor {
    private static final Log log = LogFactory.getLog(AbstractTopiaContext.class);
    @Deprecated
    protected TopiaContextImplementor parentContext;
    protected Configuration hibernateConfiguration;
    protected SessionFactory hibernateFactory;
    protected Session hibernate;
    protected boolean closed;
    protected boolean useFlushMode = true;
    protected Properties config;
    protected TopiaIdFactory topiaIdFactory;
    protected Map<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>> daoCache = new HashMap<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>>();
    protected final Set<TopiaContextImplementor> childContext = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    protected Map<String, TopiaService> services;
    protected TopiaFiresSupport firesSupport = new TopiaFiresSupport();
    protected List<Class<?>> persistenceClasses = new ArrayList();

    protected AbstractTopiaContext() {
    }

    public AbstractTopiaContext(Properties config) throws TopiaNotFoundException {
        this.config = config;
        this.initTopiaIdFactory();
        this.services = this.loadServices(config);
        this.preInitServices(this.services);
        this.getHibernateConfiguration();
        this.postInitServices(this.services);
    }

    protected void initTopiaIdFactory() {
        String configTopiaIdFactoryClassName = this.getConfig().getProperty("topia.persistence.topiaIdFactoryClassName", "");
        if (StringUtils.isEmpty((CharSequence)configTopiaIdFactoryClassName)) {
            this.topiaIdFactory = new DefaultTopiaIdFactory();
        } else {
            try {
                Class<?> configPersistenceTopiaIdFactoryClass = Class.forName(configTopiaIdFactoryClassName);
                if (!TopiaIdFactory.class.isAssignableFrom(configPersistenceTopiaIdFactoryClass)) {
                    throw new IllegalArgumentException(configTopiaIdFactoryClassName + " is not a valid class name. The class must implements " + TopiaIdFactory.class.getSimpleName());
                }
                this.topiaIdFactory = (TopiaIdFactory)configPersistenceTopiaIdFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new TopiaException(e);
            }
            catch (InstantiationException e) {
                throw new TopiaException(e);
            }
            catch (IllegalAccessException e) {
                throw new TopiaException(e);
            }
        }
    }

    protected String getProperExceptionMessage(Throwable eee) {
        return eee.getClass().getSimpleName() + " : " + eee.getMessage();
    }

    protected Map<String, TopiaService> loadServices(Properties config) {
        HashMap<String, TopiaService> result = new HashMap<String, TopiaService>();
        Enumeration<?> e = config.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.matches("^topia\\.service\\.\\w+$")) continue;
            String classService = config.getProperty(key);
            try {
                Class<?> forName = Class.forName(classService);
                Object newInstance = forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                TopiaService service = (TopiaService)newInstance;
                if (key.equals("topia.service." + service.getServiceName())) {
                    result.put(service.getServiceName(), service);
                    log.info((Object)String.format("Service '%1$s' loaded (implementation %2$s)", key, classService));
                    continue;
                }
                log.warn((Object)String.format("The service with key '%1$s' has a different name '%2$s'! (service not activated)", key, service.getServiceName()));
            }
            catch (Throwable eee) {
                String message = String.format("The service %1$s of type %2$s was not found.", key, classService);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, eee);
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)message);
            }
        }
        return result;
    }

    protected void preInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.preInit(this)) continue;
            log.warn((Object)String.format("The service named '%1$s' could not be post-initialized (service not activated)", service.getServiceName()));
        }
    }

    protected void postInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.postInit(this)) continue;
            log.warn((Object)String.format("The service named '%1$s' could not be pre-initialized (service not activated)", service.getServiceName()));
        }
    }

    protected TopiaService getService(String name) {
        TopiaService result = this.getServices().get(name);
        return result;
    }

    protected boolean serviceEnabled(String name) {
        boolean result = this.getServices().containsKey(name);
        return result;
    }

    protected <E extends TopiaService> String getServiceName(Class<E> interfaceService) throws IllegalAccessException, NoSuchFieldException {
        Field f = interfaceService.getField("SERVICE_NAME");
        String name = (String)f.get(null);
        return name;
    }

    @Override
    public Map<String, TopiaService> getServices() {
        TopiaContextImplementor parent = this.getParentContext();
        Map<String, TopiaService> result = parent != null ? parent.getServices() : this.services;
        return result;
    }

    @Override
    public <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException {
        TopiaService result;
        try {
            String name = this.getServiceName(interfaceService);
            result = this.getService(name);
        }
        catch (Exception eee) {
            throw new TopiaNotFoundException(String.format("Could not retreave service %1$s for following reason: %2$s", interfaceService, this.getProperExceptionMessage(eee)), eee);
        }
        if (result == null) {
            throw new TopiaNotFoundException(String.format("The service %1$s was not found.", interfaceService));
        }
        return (E)result;
    }

    @Override
    public <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService) {
        boolean result;
        block3: {
            result = false;
            try {
                String name = this.getServiceName(interfaceService);
                result = this.serviceEnabled(name);
            }
            catch (Exception eee) {
                String message = String.format("The service named '%1$s' could not be found for following reason: %2$s", interfaceService, this.getProperExceptionMessage(eee));
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)eee);
                }
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)message);
            }
        }
        return result;
    }

    protected AbstractTopiaContext(TopiaContextImplementor parentContext) {
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopiaContextImplementor> getChildContext() {
        HashSet<TopiaContextImplementor> values;
        Set<TopiaContextImplementor> set = this.childContext;
        synchronized (set) {
            values = new HashSet<TopiaContextImplementor>(this.childContext);
        }
        return values;
    }

    protected void addChildContext(TopiaContextImplementor child) {
        this.childContext.add(child);
    }

    @Override
    public void removeChildContext(TopiaContext child) {
        if (!this.closed) {
            this.childContext.remove(child);
        }
    }

    @Override
    public TopiaContextImplementor getParentContext() {
        return this.parentContext;
    }

    @Override
    public TopiaContextImplementor getRootContext() {
        TopiaContextImplementor result = this;
        if (this.getParentContext() != null) {
            result = this.getParentContext().getRootContext();
        }
        return result;
    }

    @Override
    public Properties getConfig() {
        if (this.config == null && this.getParentContext() != null) {
            this.config = this.getParentContext().getConfig();
        }
        return this.config;
    }

    @Override
    public TopiaIdFactory getTopiaIdFactory() {
        if (this.topiaIdFactory == null) {
            this.initTopiaIdFactory();
        }
        return this.topiaIdFactory;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    @Override
    public void createSchema() throws TopiaException {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.getFiresSupport().firePreCreateSchema(this);
            new SchemaExport(this.getHibernateConfiguration()).execute(showSchema, true, false, true);
            this.getFiresSupport().firePostCreateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void showCreateSchema() throws TopiaException {
        try {
            new SchemaExport(this.getHibernateConfiguration()).execute(true, false, false, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not show create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void updateSchema() throws TopiaException {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.getFiresSupport().firePreUpdateSchema(this);
            new SchemaUpdate(this.getHibernateConfiguration()).execute(showSchema, true);
            this.getFiresSupport().firePostUpdateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not update schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void dropSchema() throws TopiaException {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.getFiresSupport().firePreDropSchema(this);
            new SchemaExport(this.getHibernateConfiguration()).execute(showSchema, true, true, false);
            this.getFiresSupport().firePostDropSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not drop schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public Session getHibernate() throws TopiaException {
        Session result = this.getHibernateSession();
        return result;
    }

    @Override
    public SessionFactory getHibernateFactory() {
        if (this.hibernateFactory == null) {
            if (this.getParentContext() != null) {
                this.hibernateFactory = this.getParentContext().getHibernateFactory();
            } else {
                ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)this.getHibernateConfiguration().getProperties()).buildServiceRegistry();
                this.hibernateFactory = this.getHibernateConfiguration().buildSessionFactory(serviceRegistry);
                ServiceRegistryImplementor serviceRegistryInit = ((SessionFactoryImplementor)this.hibernateFactory).getServiceRegistry();
                EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistryInit.getService(EventListenerRegistry.class);
                TopiaFiresSupport.TopiaHibernateEvent listener = new TopiaFiresSupport.TopiaHibernateEvent(this);
                eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
                eventListenerRegistry.prependListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{listener});
            }
        }
        return this.hibernateFactory;
    }

    @Override
    public Configuration getHibernateConfiguration() {
        if (this.hibernateConfiguration == null) {
            if (this.getParentContext() != null) {
                this.hibernateConfiguration = this.getParentContext().getHibernateConfiguration();
            } else {
                String[] classes;
                String[] dirs;
                this.hibernateConfiguration = new Configuration();
                for (String dir : dirs = this.getConfig().getProperty("topia.persistence.directories", "").split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)(dir = dir.trim()))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistence from dir : " + dir));
                    }
                    this.hibernateConfiguration.addDirectory(new File(dir));
                }
                HashSet hibernatePersistanceClasses = new HashSet();
                for (TopiaService service : this.getServices().values()) {
                    Class<?>[] classes2 = service.getPersistenceClasses();
                    if (classes2 == null) continue;
                    hibernatePersistanceClasses.addAll(Arrays.asList(classes2));
                }
                String listPersistenceClasses = this.getConfig().getProperty("topia.persistence.classes", "");
                for (String classname : classes = listPersistenceClasses.split(",")) {
                    Class<?> clazz;
                    if (!StringUtils.isNotEmpty((CharSequence)(classname = classname.trim()))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistent class : " + classname));
                    }
                    try {
                        clazz = Class.forName(classname);
                    }
                    catch (ClassNotFoundException eee) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Class " + classname + " not found"));
                        }
                        throw new TopiaNotFoundException(String.format("Persistence class %1$s not found", classname));
                    }
                    this.persistenceClasses.add(clazz);
                    hibernatePersistanceClasses.add(clazz);
                }
                for (Class clazz : hibernatePersistanceClasses) {
                    this.hibernateConfiguration.addClass(clazz);
                }
                Properties prop = new Properties();
                prop.putAll((Map<?, ?>)this.hibernateConfiguration.getProperties());
                prop.putAll((Map<?, ?>)this.getConfig());
                Properties properties = TopiaUtil.getProperties(this.getConfig().getProperty("topia.persistence.properties.file"));
                if (!properties.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load properties from file : " + properties));
                    }
                    prop.putAll((Map<?, ?>)properties);
                }
                this.hibernateConfiguration.setProperties(prop);
                this.hibernateConfiguration.buildMappings();
            }
        }
        return this.hibernateConfiguration;
    }

    @Override
    public <E extends TopiaEntity> TopiaDAO<E> getDAO(Class<E> entityClass) throws TopiaException {
        if (entityClass == null) {
            throw new IllegalArgumentException(String.format("The method '%1$s' requires a non null parameter '%2$s'.", "entityClass", "getDAO"));
        }
        if (this.equals(this.getRootContext())) {
            throw new TopiaException("You are on root context, you MUST open a transaction to perform any database access.");
        }
        if (this.getHibernateFactory().getClassMetadata(entityClass) == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Impl") == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Abstract") == null) {
            log.info((Object)String.format("List of supported persistence classes: %1$s", this.getHibernateFactory().getAllClassMetadata().keySet()));
            throw new TopiaException(String.format("The following entity type %1$s is not managed by this context, you probably forgot to declare it.", entityClass.getName()));
        }
        TopiaDAOImpl<E> result = (TopiaDAOImpl<E>)this.daoCache.get(entityClass);
        if (result == null) {
            String daoClassname = entityClass.getName() + "DAO";
            try {
                Class<?> daoClass = Class.forName(daoClassname);
                TopiaDAOImpl spe = (TopiaDAOImpl)daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                result = spe;
            }
            catch (Exception eee) {
                log.warn((Object)("specialized DAO " + daoClassname + " not found, use default TopiaDAOHibernate"));
                result = new TopiaDAOImpl<E>();
            }
            result.init(this, entityClass, this.getFiresSupport());
            this.daoCache.put(entityClass, result);
        }
        return result;
    }

    @Override
    public <E extends TopiaEntity, D extends TopiaDAO<E>> D getDAO(Class<E> entityClass, Class<D> daoClass) throws TopiaException {
        return (D)this.getDAO(entityClass);
    }

    @Override
    public TopiaContext beginTransaction() throws TopiaException {
        this.checkClosed("Context is closed, no operation is possible.");
        AbstractTopiaContext result = new AbstractTopiaContext(this);
        SessionFactory factory = this.getHibernateFactory();
        result.hibernate = factory.openSession();
        result.hibernate.setFlushMode(FlushMode.MANUAL);
        result.useFlushMode = this.useFlushMode;
        try {
            result.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.hibernate.close();
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close hibernate session", (Throwable)e1);
                }
            }
            throw new TopiaException(String.format("An error occurs while asking a new transaction: %1$s", eee.getMessage()), eee);
        }
        this.addChildContext(result);
        this.getFiresSupport().fireOnBeginTransaction(result);
        return result;
    }

    @Override
    public void commitTransaction() throws TopiaException {
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(String.format("Unsupported operation %s on root context", "commit"));
        }
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "commit"));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.flush();
            tx.commit();
            this.getFiresSupport().fireOnPostCommit(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostCommit(this);
            }
            this.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            throw new TopiaException(String.format("An error occurs while commit operation: %1$s", eee.getMessage()), eee);
        }
    }

    @Override
    public void rollbackTransaction() throws TopiaException {
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(String.format("Unsupported operation %s on root context", "rollback"));
        }
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "rollback"));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.clear();
            tx.rollback();
            this.hibernate.close();
            this.hibernate = this.getHibernateFactory().openSession();
            this.hibernate.setFlushMode(FlushMode.MANUAL);
            this.hibernate.beginTransaction();
            this.getFiresSupport().fireOnPostRollback(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostRollback(this);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while rollback operation: %1$s", eee.getMessage()), eee);
        }
    }

    @Override
    public void closeContext() throws TopiaException {
        this.checkClosed("Context was already closed");
        for (TopiaContextImplementor child : this.getChildContext()) {
            if (child.isClosed()) continue;
            child.closeContext();
        }
        if (!this.equals(this.getRootContext())) {
            this.closed = true;
            this.hibernate.close();
            this.getParentContext().removeChildContext(this);
        } else if (this.hibernateFactory != null) {
            this.hibernateFactory.close();
            ConnectionProvider service = (ConnectionProvider)((SessionFactoryImplementor)this.hibernateFactory).getServiceRegistry().getService(ConnectionProvider.class);
            if (service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
            this.closed = true;
            TopiaContextFactory.removeContext(this);
            log.debug((Object)"TopiaContext removed");
        }
    }

    protected void finalize() throws Throwable {
        if (this.hibernateFactory != null) {
            this.closeContext();
            this.hibernateFactory.close();
            this.closed = true;
            log.debug((Object)"TopiaContext finalized");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void executeSQL(String sqlScript) throws TopiaException {
        SQLWork sqlWork = new SQLWork(sqlScript);
        try {
            this.getHibernate().doWork((Work)sqlWork);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    protected void checkClosed(String message) throws TopiaException {
        if (this.closed) {
            throw new TopiaException(message);
        }
    }

    @Override
    public <E extends TopiaEntity> E findByTopiaId(String id) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "findByTopiaId"));
        Class entityClass = this.getTopiaIdFactory().getClassName(id);
        TopiaDAO dao = this.getDAO(entityClass);
        Object result = dao.findByTopiaId(id);
        return result;
    }

    @Override
    public <E> List<E> findAll(String jpaql, Object ... propertyNamesAndValues) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "findAll"));
        try {
            Query query = this.getHibernate().createQuery(jpaql);
            for (int j = 0; j < propertyNamesAndValues.length; j += 2) {
                String name = (String)propertyNamesAndValues[j];
                Object value = propertyNamesAndValues[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while query operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
    }

    @Override
    public <E> List<E> find(String jpaql, int startIndex, int endIndex, Object ... propertyNamesAndValues) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "find"));
        try {
            Query query = this.getHibernate().createQuery(jpaql);
            for (int j = 0; j < propertyNamesAndValues.length; j += 2) {
                String name = (String)propertyNamesAndValues[j];
                Object value = propertyNamesAndValues[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            query.setFirstResult(startIndex);
            query.setMaxResults(endIndex - startIndex + 1);
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while query operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
    }

    @Override
    public <E> E findUnique(String jpaql, Object ... propertyNamesAndValues) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "findUnique"));
        List<E> results = this.find(jpaql, 0, 1, propertyNamesAndValues);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", jpaql);
            throw new TopiaException(message);
        }
        E result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    @Override
    public int execute(String jpaql, Object ... propertyNamesAndValues) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "find"));
        try {
            Query query = this.getHibernate().createQuery(jpaql);
            for (int j = 0; j < propertyNamesAndValues.length; j += 2) {
                query.setParameter((String)propertyNamesAndValues[j], propertyNamesAndValues[j + 1]);
            }
            int result = query.executeUpdate();
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while query operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
    }

    @Override
    public void add(TopiaEntity e) throws TopiaException {
        this.update(e);
    }

    @Override
    public void replicate(TopiaContext dstCtxt, Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicate"));
        AbstractTopiaContext dstContextImpl = (AbstractTopiaContext)dstCtxt;
        dstContextImpl.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicate"));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException("Can not do a replication operation on same database.");
        }
        String[] queries = this.buildQueries(entityAndCondition);
        try {
            for (String query : queries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("acquire entities " + query));
                }
                List entities = this.findAll(query, new Object[0]);
                this.replicate0(dstContextImpl, entities.toArray());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("replication of entities " + query + " was sucessfully done."));
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while a replication operation: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaContext dstCtxt, T entity) throws TopiaException, IllegalArgumentException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicateEntity"));
        AbstractTopiaContext dstContextImpl = (AbstractTopiaContext)dstCtxt;
        dstContextImpl.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicateEntity"));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException("Can not do a replication operation on same database.");
        }
        this.replicate0(dstContextImpl, entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaContext dstCtxt, List<T> entities) throws TopiaException, IllegalArgumentException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicateEntities"));
        AbstractTopiaContext dstContextImpl = (AbstractTopiaContext)dstCtxt;
        dstContextImpl.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicateEntities"));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException("Can not do a replication operation on same database.");
        }
        this.replicate0(dstContextImpl, entities.toArray());
    }

    @Override
    public TopiaFiresSupport getFiresSupport() {
        return this.firesSupport;
    }

    @Override
    public void backup(File file, boolean compress) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "backup"));
        try {
            String options = "";
            if (compress) {
                options = options + " COMPRESSION GZIP";
            }
            SQLQuery query = this.getHibernate().createSQLQuery("SCRIPT TO '" + file.getAbsolutePath() + "'" + options);
            query.list();
        }
        catch (Exception eee) {
            throw new TopiaException(String.format("An error occurs while backup operation: %1$s", eee.getMessage()), eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(File file) throws TopiaException {
        this.getFiresSupport().firePreRestoreSchema(this);
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "restore"));
        Object sql = null;
        String options = "";
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                ((InputStream)in).mark(2);
                int b = ((InputStream)in).read();
                int magic = ((InputStream)in).read() << 8 | b;
                ((InputStream)in).reset();
                if (magic == 35615) {
                    options = options + " COMPRESSION GZIP";
                }
            }
            finally {
                ((InputStream)in).close();
            }
            SQLQuery query = this.getHibernate().createSQLQuery("RUNSCRIPT FROM '" + file.getAbsolutePath() + "'" + options);
            query.executeUpdate();
            this.getFiresSupport().firePostRestoreSchema(this);
        }
        catch (Exception eee) {
            throw new TopiaException(String.format(String.format("An error occurs while restore operation: %1$s : %2$s", sql, eee.getMessage()), new Object[0]), eee);
        }
    }

    @Override
    public void clear(boolean dropDatabase) throws TopiaException {
        try {
            AbstractTopiaContext root = (AbstractTopiaContext)this.getRootContext();
            AbstractTopiaContext tx = (AbstractTopiaContext)root.beginTransaction();
            String sql = "DROP ALL OBJECTS";
            if (dropDatabase) {
                sql = sql + " DELETE FILES";
            }
            SQLQuery query = tx.getHibernate().createSQLQuery(sql);
            query.executeUpdate();
            tx.closeContext();
            root.finalize();
        }
        catch (Throwable eee) {
            throw new TopiaException(String.format("Error %s on clear operation", eee.getMessage()), eee);
        }
    }

    @Override
    public void clearCache() throws TopiaException {
        this.getHibernate().clear();
    }

    @Override
    public List<Class<?>> getPersistenceClasses() {
        return this.persistenceClasses;
    }

    @Override
    public boolean isSchemaExist(Class<?> clazz) throws TopiaException {
        return this.isTableExists(clazz);
    }

    @Override
    public boolean isSchemaEmpty() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isTableExists(Class<?> clazz) {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "replicateEntity"));
        boolean result = TopiaUtil.isSchemaExist(this, clazz.getName());
        return result;
    }

    @Override
    public String getSchemaName() {
        return this.getConfig().getProperty("hibernate.default_schema");
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().addTopiaTransactionListener(listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().addTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().addPropertyChangeListener(listener);
    }

    @Override
    @Deprecated
    public void addTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().addTopiaContextListener(listener);
    }

    @Override
    public void addTopiaSchemaListener(TopiaSchemaListener listener) {
        this.getFiresSupport().addTopiaSchemaListener(listener);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(TopiaEntity.class, listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().removeTopiaTransactionListener(listener);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().removeTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().removePropertyChangeListener(listener);
    }

    @Override
    @Deprecated
    public void removeTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().removeTopiaContextListener(listener);
    }

    @Override
    public void removeTopiaSchemaListener(TopiaSchemaListener listener) {
        this.getFiresSupport().removeTopiaSchemaListener(listener);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().addTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntitiesVetoable(vetoable);
    }

    protected String[] buildQueries(Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        int i;
        if (entityAndCondition.length == 0) {
            Map classMetadata = this.getHibernateFactory().getAllClassMetadata();
            entityAndCondition = new Object[classMetadata.size() * 2];
            i = 0;
            for (Object className : classMetadata.keySet()) {
                try {
                    entityAndCondition[i++] = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("class cast exception for entity " + className);
                }
                entityAndCondition[i++] = null;
            }
        }
        if (entityAndCondition.length % 2 != 0) {
            throw new IllegalArgumentException("entityAndCondition must be a couple of (Class, String)");
        }
        String[] queries = new String[entityAndCondition.length / 2];
        i = 0;
        while (i < entityAndCondition.length) {
            try {
                Class entityClass = (Class)entityAndCondition[i++];
                String condition = (String)entityAndCondition[i++];
                String query = "from " + entityClass.getName();
                if (condition != null && !condition.isEmpty()) {
                    query = query + " where " + condition;
                }
                queries[(i - 1) / 2] = query;
            }
            catch (ClassCastException e) {
                if (i % 2 == 0) {
                    throw new IllegalArgumentException("Others arguement must be String not " + entityAndCondition[i - 1], e);
                }
                throw new IllegalArgumentException("Others arguement must be Class not " + entityAndCondition[i - 1], e);
            }
        }
        return queries;
    }

    protected void replicate0(AbstractTopiaContext dstContextImpl, Object ... entities) throws TopiaException {
        try {
            for (Object entity : entities) {
                this.getHibernate().evict(entity);
                dstContextImpl.getHibernate().replicate(entity, ReplicationMode.EXCEPTION);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while a replication operation : %s", eee.getMessage()), eee);
        }
    }

    @Override
    public Session getHibernateSession() throws TopiaException {
        if (this.hibernate == null) {
            throw new TopiaException("No hibernate session");
        }
        return this.hibernate;
    }

    @Override
    public void update(TopiaEntity entity) throws TopiaException {
        this.checkClosed(String.format("This context is closed, it is not possible to release the operation '%1$s'", "add"));
        String id = entity.getTopiaId();
        Class entityClass = this.getTopiaIdFactory().getClassName(id);
        TopiaDAO<TopiaEntity> dao = this.getDAO(entityClass);
        dao.update(entity);
    }

    public static class SQLWork
    implements Work {
        private final String script;

        public SQLWork(String script) {
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) throws SQLException {
            PreparedStatement sta = connection.prepareStatement(this.script);
            try {
                sta.execute();
            }
            finally {
                sta.close();
            }
        }
    }
}

