/*
 * #%L
 * EchoBase :: Entities
 * 
 * $Id: MetaFilenameAware.java 2620 2012-08-16 16:18:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.8-rc-1/topia-persistence/src/main/java/org/nuiton/topia/persistence/metadata/MetaFilenameAware.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.persistence.metadata;

import org.nuiton.topia.persistence.TopiaEntityEnum;

import java.io.File;
import java.io.Writer;

/**
 * Contract to import or export some metas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.6.12
 */
public interface MetaFilenameAware<T extends TopiaEntityEnum> {

    String CSV_EXTENSION = ".csv";

    T getSource();

    String getName();

    String getFilename();

    File newFile(File container);

    Writer newWriter(File container);

}
