package org.nuiton.topia.test.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class PetDAOAbstract<E extends Pet> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Pet.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Pet.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.NAME, v);
        return result;
    }

    /**
     * findByType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(Pet.TYPE, v);
        return result;
    }

    /**
     * findAllByType :
     * Retourne les éléments ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.TYPE, v);
        return result;
    }

    /**
     * findByPerson :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut person le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPerson(Person v) throws TopiaException {
        E result = findByProperty(Pet.PERSON, v);
        return result;
    }

    /**
     * findAllByPerson :
     * Retourne les éléments ayant comme valeur pour l'attribut person le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPerson(Person v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PERSON, v);
        return result;
    }

    /**
     * findByRace :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut race le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRace(Race v) throws TopiaException {
        E result = findByProperty(Pet.RACE, v);
        return result;
    }

    /**
     * findAllByRace :
     * Retourne les éléments ayant comme valeur pour l'attribut race le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRace(Race v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.RACE, v);
        return result;
    }


} //PetDAOAbstract<E extends Pet>
