package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;


public abstract class EmployeDAOAbstract<E extends Employe> extends PersonneDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Employe.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<org.nuiton.topiatest.Department> list = getContext()
                            .getDAO(org.nuiton.topiatest.Department.class)
                            .findAllByProperties("leader", entity);
                    for (org.nuiton.topiatest.Department item : list) {
                        item.setLeader(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findBySalary :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut salary le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySalary(int v) throws TopiaException {
        E result = findByProperty("salary", v);
        return result;
    }

    /**
     * findAllBySalary :
     * Retourne les éléments ayant comme valeur pour l'attribut salary le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySalary(int v) throws TopiaException {
        List<E> result = findAllByProperty("salary", v);
        return result;
    }


} //EmployeDAOAbstract<E extends Employe>
