/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.filters;

import java.io.LineNumberReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.filters.Filter;

public abstract class DefaultFilter
implements Filter {
    public static final int NOT_FOUND = -1;
    private static final Log log = LogFactory.getLog(DefaultFilter.class);
    protected LineNumberReader reader;
    protected StringBuffer cachedContent = new StringBuffer();
    protected State state = State.SEARCH_HEADER;

    protected abstract String performInFilter(String var1);

    protected abstract String performOutFilter(String var1);

    protected abstract String getHeader();

    protected abstract String getFooter();

    @Override
    public void setReader(LineNumberReader reader) {
        this.reader = reader;
    }

    public int getLineNumber() {
        int result = -1;
        if (this.reader != null) {
            result = this.reader.getLineNumber();
        }
        return result;
    }

    @Override
    public String parse(String input) {
        this.cachedContent.append(input);
        String content = this.cachedContent.toString();
        if (this.state.equals((Object)State.SEARCH_HEADER)) {
            int matchingIndex = this.getMatchIndexFor(content, this.getHeader());
            if (matchingIndex != -1) {
                this.changeState(State.SEARCH_FOOTER);
                StringBuilder buffer = new StringBuilder();
                String outFilter = this.performOutFilter(content.substring(0, matchingIndex));
                buffer.append(outFilter);
                buffer.append(this.parse(content.substring(matchingIndex)));
                return buffer.toString();
            }
            return "";
        }
        if (this.state.equals((Object)State.SEARCH_FOOTER)) {
            int matchingIndex = this.getMatchIndexFor(content, this.getFooter());
            if (matchingIndex != -1) {
                this.changeState(State.SEARCH_HEADER);
                int matchingEndIndex = matchingIndex + this.getMatchLengthFor(this.getFooter());
                StringBuilder buffer = new StringBuilder();
                String headerFootfilter = this.performHeaderFooterFilter(content.substring(0, matchingEndIndex));
                String inFilter = this.performInFilter(headerFootfilter);
                buffer.append(inFilter);
                buffer.append(this.parse(content.substring(matchingEndIndex)));
                return buffer.toString();
            }
            return "";
        }
        throw new IllegalStateException("state " + (Object)((Object)this.state) + " is unkwon...");
    }

    public String performHeaderFooterFilter(String ch) {
        return ch.substring(this.getHeader().length(), ch.length() - this.getFooter().length());
    }

    public int getMatchIndexFor(String input, String sequence) {
        return input.indexOf(sequence);
    }

    public int getMatchLengthFor(String sequence) {
        return sequence.length();
    }

    @Override
    public boolean hasCachedData() {
        return this.cachedContent.length() > 0;
    }

    @Override
    public String flush() {
        String line = this.cachedContent.toString();
        this.cachedContent.setLength(0);
        if (this.state.equals((Object)State.SEARCH_HEADER)) {
            return this.performOutFilter(line);
        }
        return this.performInFilter(line);
    }

    protected void changeState(State newState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("change state : <old:" + (Object)((Object)this.state) + ", new:" + (Object)((Object)newState) + ">"));
        }
        this.state = newState;
        this.cachedContent.setLength(0);
    }

    protected static enum State {
        SEARCH_HEADER,
        SEARCH_FOOTER;

    }
}

