/*
 * #%L
 * Nuiton Processor :: Api
 * 
 * $Id: I18nExtractor.java 368 2011-01-20 07:24:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/processor/tags/processor-1.1/nuiton-processor/src/main/java/org/nuiton/processor/I18nExtractor.java $
 * %%
 * Copyright (C) 2002 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


/* *
 * I18nExtractor.java
 *
 * Created: Aug 16, 2004
 *
 * @author Cédric Pineau <pineau@codelutin.com>
 * @version $Revision: 368 $
 *
 * Last update : $Date: 2011-01-20 08:24:57 +0100 (Thu, 20 Jan 2011) $
 * by : */

package org.nuiton.processor;

import org.nuiton.processor.filters.I18nFilter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @deprecated since 1.1, will not be replaced in this project, but you can find
 * it in I18n project. Will be remove soon.
 */
@Deprecated
public class I18nExtractor {

    protected I18nFilter filter = new I18nFilter();

    protected Map<String, List<String>> store =
            new HashMap<String, List<String>>();

    /**
     * Process input file to target.
     *
     * @param srcFiles   source files
     * @param outputFile target file
     * @param encoding   encoding used to read and write files
     * @throws IOException if any io problems
     * @since 1.0.4
     */
    public void extract(File[] srcFiles, File outputFile, String encoding) throws IOException {
        PrintWriter writer = new PrintWriter(
                new BufferedWriter(
                        new OutputStreamWriter(
                                new FileOutputStream(outputFile), encoding)));
        try {
            for (File srcFile : srcFiles) {
                processFile(srcFile, encoding);
            }

            for (Object o : store.keySet()) {
                String i18nString = (String) o;
                List<?> locations = store.get(i18nString);
                for (Object location1 : locations) {
                    String location = (String) location1;
                    writer.println("# " + location);
                }
                writer.println(i18nString + "=");
            }
        } finally {
            writer.close();
        }
    }

    /**
     * @param srcFiles   source files
     * @param outputFile target file
     * @throws IOException if any io problems
     * @deprecated since 1.0.4, prefer use the {@link #extract(File[], File, String)}
     */
    @Deprecated
    public void extract(File[] srcFiles, File outputFile) throws IOException {
        extract(srcFiles, outputFile, "UTF-8");
//        PrintWriter writer = new PrintWriter(
//                new BufferedWriter(
//                        new OutputStreamWriter(
//                                new FileOutputStream(outputFile), "UTF-8")));
//        try {
//            for (File srcFile : srcFiles) {
//                processFile(srcFile);
//            }
//
//            for (Object o : store.keySet()) {
//                String i18nString = (String) o;
//                List<?> locations = store.get(i18nString);
//                for (Object location1 : locations) {
//                    String location = (String) location1;
//                    writer.println("# " + location);
//                }
//                writer.println(i18nString + "=");
//            }
//        } finally {
//            writer.close();
//        }
    }

    protected void processFile(File srcFile, String encoding) throws IOException {
        LineNumberReader lnr = new LineNumberReader(
                new InputStreamReader(new FileInputStream(srcFile), encoding));
        try {
            while (lnr.ready()) {
                String line = lnr.readLine();
                int lineNumber = lnr.getLineNumber();
                processLine(line, srcFile, lineNumber);
            }
        } finally {
            lnr.close();
        }
    }

    protected void processLine(String line, File srcFile, int lineNumber) {
        String i18nStringsSet = filter.parse(line);
        if (I18nFilter.EMPTY_STRING.equals(i18nStringsSet)) {
            // Found a set of i18n Strings, split it.
            String[] i18nStrings = i18nStringsSet.split("=");
            for (String i18nString : i18nStrings) {
                List<String> locations = store.get(i18nString);
                if (locations == null) {
                    locations = new ArrayList<String>();
                    store.put(i18nString, locations);
                }
                locations.add(srcFile.getPath() + "(" + lineNumber + ")");
            }
        }
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger("org.nuiton.processor.I18nExtractor.");

        if (args.length < 2) {
            logger.log(Level.SEVERE,
                    "Please give at least sources and destination file");
            System.exit(0);
        } else if (args.length > 2) {
            File[] sources = new File[args.length - 1];
            for (int i = 0; i < args.length - 1; i++) {
                sources[i] = new File(args[i]);
            }
            File destination = new File(args[args.length - 1]);
            try {
                String encoding = ProcessorUtil.DEFAULT_ENCODING;
                logger.log(Level.INFO, "Will use system encoding " + encoding);
                new I18nExtractor().extract(sources, destination, encoding);
            } catch (IOException eee) {

                logger.log(Level.SEVERE,
                           "Error during i18n extraction : " + eee, eee);
            }
        }

    }
}
