/*
 * *##% 
 * Nuiton Processor :: Api
 * Copyright (C) 2002 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.processor.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Un filtre pour remplacer la license d'un fichier source java.
 * <p/>
 * fixme : il faut ne pas autoriser le process de fichier java qui ne sont pas
 *  valide selon le header - footer...
 *
 * @author chemit
 */
public class LicenseFilter extends DefaultFilter {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(LicenseFilter.class);

    public static final String HEADER = "*" + "#" + "#" + "%";

    public static final String FOOTER = "#" + "#" + "%" + "*";

    /**
     * la licence a insere dans le header du fichier source. Ce header est
     * formatte en commentaire (chaque ligne commence par un ' * ', sauf pour
     * la premiere et derniere ligne).
     */
    protected String licenseHeader;
    
    /** flag pour indiquer si la licence a ete trouvee entre le header et
     * le footer */
    protected boolean touched;

    /** flag pour indiquer si on a rencontree le header du filtre  */
    protected boolean detectHeader;

    public LicenseFilter(String licenseHeader) {
        this.licenseHeader = " " + licenseHeader + " ";
    }

    @Override
    protected String performInFilter(String ch) {
        if (log.isDebugEnabled()) {
            log.debug(ch);
        }
        if (touched) {
            // on autorise pas deux process de la licence dans un fichier java
            throw new IllegalStateException("Can only have one license " +
                                            "processor open tag " + HEADER);
        }
        if (getMatchIndexFor(ch, HEADER) == NOT_FOUND) {
            // on est bien dans la license, on peut effectuer le changement
            touched = true;
            return HEADER + licenseHeader + FOOTER;
        }
        // ce cas arrive lorsque l'on a parcouru tout le fichier avec detection
        // de la balise header mais sans balise footer
        // et on arrive dans cette methode dans le flush du filter
        return ch;
    }

    @Override
    protected String performOutFilter(String ch) {
        if (log.isDebugEnabled()) {
            log.debug(ch);
        }
        return ch;
    }

    @Override
    protected String getHeader() {
        return HEADER;
    }

    @Override
    protected String getFooter() {
        return FOOTER;
    }

    @Override
    protected void changeState(State newState) {
        super.changeState(newState);
        if (newState == State.SEARCH_FOOTER) {
            // on a decouvert un header
            detectHeader = true;
        }
    }

    public boolean wasTouched() {
        return touched;
    }

    public boolean isDetectHeader() {
        return detectHeader;
    }

    public void reset() {
        touched = false;
        detectHeader = false;
        state = State.SEARCH_HEADER;
    }
}
