/*
 * *##% 
 * Nuiton Processor :: Api
 * Copyright (C) 2002 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

/* *
 * GeneratorTemplatesProcessor.java
 *
 * Created: Wed Sep  4 2002
 *
 * @author  <pineau@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 317 $
 *
 * Mise a jour: $Date: 2010-03-09 19:22:11 +0100 (mar., 09 mars 2010) $
 * par : $Author: tchemit $
 */

package org.nuiton.processor;

import java.io.IOException;

import org.nuiton.processor.filters.GeneratorTemplatesFilter;

public class GeneratorTemplatesProcessor extends Processor {

    public GeneratorTemplatesProcessor(){
        setInputFilter(new GeneratorTemplatesFilter());
    }

    static public void process(String filein, String fileout)
    throws IOException{
        Processor processor = new GeneratorTemplatesProcessor();
        ProcessorUtil.doProcess(processor,filein,fileout);
//        processor.process(new FileReader(filein), new FileWriter(fileout));
    }

    public static void main(String [] args)throws IOException{
        if(args.length < 2) {
            System.out.println("Give source and destination file");
            System.exit(1);
        } else {
            process(args[0], args[1]);
        }
    }
}
