/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.ActiveLogsCodeFilter;
import org.nuiton.processor.filters.RemoveLogsCodeFilter;

public class LogsProcessor
extends Processor {
    public static final Action NoAction = new Action();
    public static final Action Logs = new Action();
    public static final Action NoLogsCode = new Action();

    public LogsProcessor(Action action) {
        if (action != NoAction) {
            if (action == NoLogsCode) {
                this.setInputFilter(new RemoveLogsCodeFilter());
            } else {
                this.setInputFilter(new ActiveLogsCodeFilter());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Give source and destination file, then action");
            System.out.println("Action may be remove or active (default is no action)");
            System.exit(0);
        } else if (args.length > 2) {
            LogsProcessor processor;
            if (args[2].equals("remove")) {
                processor = new LogsProcessor(NoLogsCode);
                System.out.println("Removing logs code");
            } else if (args[2].equals("active")) {
                processor = new LogsProcessor(Logs);
                System.out.println("Setting logs active");
            } else {
                processor = new LogsProcessor(NoAction);
                System.out.println("No action taken");
            }
            try {
                processor.process(new FileReader(args[0]), new FileWriter(args[1]));
            }
            catch (IOException eee) {
                Logger.getLogger("org.nuiton.processor.LogsProcessor.").severe("Error during log processing: " + eee);
            }
        }
    }

    protected static class Action {
        protected Action() {
        }
    }
}

