/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.nuiton.j2r.types.REXP;
import org.nuiton.j2r.types.REXPAbstract;

public class RList
extends REXPAbstract
implements REXP {
    protected List<Object> data;
    protected Log log;

    public RList(REngine engine) {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.data = new ArrayList<Object>();
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RList(List<String> names, List<Object> data, REngine engine, String variable) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = names;
        this.data = data;
        this.variable = variable;
        this.attributes = new HashMap();
        this.engine = engine;
        try {
            engine.voidEval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("Cannot initialize list in R", eee);
        }
    }

    public RList(String[] names, List<Object> data, REngine engine, String variable) throws RException {
        block3: {
            this.log = LogFactory.getLog(RDataFrame.class);
            String[] tempNames = new String[]{};
            if (names != null) {
                tempNames = (String[])names.clone();
            }
            this.names = new ArrayList();
            this.names.addAll(Arrays.asList(tempNames));
            this.data = data;
            this.variable = variable;
            this.attributes = new HashMap();
            this.engine = engine;
            try {
                engine.eval(this.toRString());
            }
            catch (RException eee) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Cannot initialize data.frame in R : " + eee.getMessage()));
            }
        }
    }

    @Override
    public String toRString() throws RException {
        this.checkVariable();
        StringBuilder returnString = new StringBuilder();
        returnString.append(this.variable);
        returnString.append("<-list(");
        if (this.data != null && !this.data.isEmpty()) {
            for (int i = 0; i < this.data.size(); ++i) {
                returnString.append(this.toRString(i));
            }
            returnString = new StringBuilder(returnString.substring(0, returnString.length() - 1));
        }
        returnString.append(")");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)returnString);
        }
        return returnString.toString();
    }

    protected String toRString(int i) throws RException {
        String returnString = "";
        Object obj = this.data.get(i);
        if (!this.names.isEmpty()) {
            returnString = returnString + (String)this.names.get(i) + "=";
        }
        returnString = obj instanceof String ? returnString + "\"" + obj + "\"," : (obj instanceof Boolean && (Boolean)obj != false ? returnString + "TRUE," : (obj instanceof Boolean && (Boolean)obj == false ? returnString + "FALSE," : (obj instanceof Integer ? returnString + String.format("as.integer(%s)", obj) + "," : (obj instanceof REXP ? returnString + ((REXP)obj).toRString() + "," : returnString + obj + ","))));
        return returnString;
    }

    public void set(int x, Double data) throws RException {
        this.checkVariable();
        this.setInData(x, data);
        this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, data));
    }

    public void set(int x, Integer data) throws RException {
        this.checkVariable();
        this.setInData(x, data);
        String asInteger = String.format("as.integer(%s)", data);
        this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, asInteger));
    }

    public void set(int x, Boolean data) throws RException {
        this.checkVariable();
        this.setInData(x, data);
        if (data.booleanValue()) {
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "TRUE"));
        } else {
            this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "FALSE"));
        }
    }

    public void set(int x, String data) throws RException {
        this.checkVariable();
        this.setInData(x, data);
        this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, "\"" + data + "\""));
    }

    public void set(int x, REXP data) throws RException {
        this.checkVariable();
        this.setInData(x, data);
        this.engine.voidEval(data.toRString());
        this.engine.voidEval(String.format("%s[[%s]]<-%s", this.variable, x + 1, data.getVariable()));
    }

    protected void setInData(int x, Object data) {
        for (int i = 0; i <= x; ++i) {
            try {
                this.data.get(i);
                if (x != i) continue;
                this.data.set(x, data);
                continue;
            }
            catch (IndexOutOfBoundsException eee) {
                if (x == i) {
                    this.data.add(data);
                    continue;
                }
                this.data.add(null);
            }
        }
    }

    public Object get(int x) throws RException {
        this.checkX(x);
        if (this.engine.isAutoCommit().booleanValue()) {
            this.checkVariable();
            Object returnObject = this.engine.eval(String.format("%s[[%s]]", this.variable, x + 1));
            if (returnObject instanceof String) {
                this.data.set(x, returnObject);
            } else if (returnObject instanceof Double) {
                this.data.set(x, returnObject);
            } else if (returnObject instanceof Integer) {
                this.data.set(x, returnObject);
            } else if (returnObject instanceof Boolean) {
                this.data.set(x, returnObject);
            }
        }
        return this.data.get(x);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) throws RException {
        this.data = data;
        this.engine.voidEval(this.toRString());
    }

    @Override
    public void getFrom(String variable) throws RException {
        this.variable = variable;
        if (this.names != null) {
            this.names.clear();
        } else {
            this.names = new ArrayList();
        }
        if (this.data != null) {
            this.data.clear();
        } else {
            this.data = new ArrayList<Object>();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        } else {
            this.attributes = new HashMap();
        }
        String[] namesArray = (String[])this.engine.eval(String.format("names(%s)", this.variable));
        this.names.addAll(Arrays.asList(namesArray));
        int length = (Integer)this.engine.eval(String.format("length(%s)", variable));
        for (int i = 0; i < length; ++i) {
            this.data.add(this.engine.eval(String.format("%s[[%s]]", this.variable, i + 1)));
        }
        Integer attributeslength = (Integer)this.engine.eval(String.format("length(attributes(%s))", this.variable));
        for (int i = 0; i < attributeslength; ++i) {
            String key = (String)this.engine.eval(String.format("names(attributes(%s))[%s]", this.variable, i + 1));
            Object attribute = this.engine.eval(String.format("attr(%s,\"%s\")", this.variable, key));
            this.attributes.put(key, attribute);
        }
    }

    @Override
    public void checkX(int x) {
        if (x > this.data.size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder("");
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.names != null && !this.names.isEmpty() && this.names.get(i) != null) {
                returnString.append("[[");
                returnString.append((String)this.names.get(i));
                returnString.append("]]\n");
            } else {
                returnString.append("[[");
                returnString.append(i);
                returnString.append("]]\n");
            }
            returnString.append(this.data.get(i));
            returnString.append("\n\n");
        }
        return returnString.toString();
    }
}

