/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.io;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.nuiton.config.plugin.io.ConfigModelIO;
import org.nuiton.config.plugin.io.ReadConfigModelException;
import org.nuiton.config.plugin.io.WriteConfigModelException;
import org.nuiton.config.plugin.model.ActionModel;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;

public class ConfigModelIOYamlImpl
implements ConfigModelIO {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigModel read(Path path) throws ReadConfigModelException {
        try (BufferedReader fileReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ConfigModel configModel;
            YamlReader reader = new YamlReader((Reader)fileReader, this.createConfig());
            ConfigModel configModel2 = configModel = (ConfigModel)reader.read(ConfigModel.class);
            return configModel2;
        }
        catch (Exception e) {
            throw new ReadConfigModelException("Can't real yaml config model from file: " + path, e);
        }
    }

    @Override
    public void write(ConfigModel configModel, Path path) throws WriteConfigModelException {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            YamlWriter writer = new YamlWriter((Writer)fileWriter, this.createConfig());
            writer.write((Object)configModel);
            ((Writer)fileWriter).flush();
            writer.close();
        }
        catch (Exception e) {
            throw new WriteConfigModelException("Can't write yaml config model from file: " + path, e);
        }
    }

    private YamlConfig createConfig() {
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.setClassTag("option", OptionModel.class);
        yamlConfig.setClassTag("action", ActionModel.class);
        yamlConfig.writeConfig.setIndentSize(2);
        yamlConfig.writeConfig.setWriteRootTags(false);
        return yamlConfig;
    }
}

