/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ReverseFileReader
implements Closeable {
    protected String filename;
    protected RandomAccessFile randomfile;
    protected long position;

    public ReverseFileReader(File file) throws IOException {
        this.randomfile = new RandomAccessFile(file, "r");
        this.position = this.randomfile.length();
        this.randomfile.seek(this.position);
        String thisLine = this.randomfile.readLine();
        while (thisLine == null) {
            --this.position;
            this.randomfile.seek(this.position);
            thisLine = this.randomfile.readLine();
            this.randomfile.seek(this.position);
        }
    }

    public ReverseFileReader(String filename) throws IOException {
        this(filename != null ? new File(filename) : null);
    }

    public String readLine() throws IOException {
        String finalLine = "";
        if (this.position < 0L) {
            return null;
        }
        while (this.position >= 0L) {
            this.randomfile.seek(this.position);
            byte thisCode = this.randomfile.readByte();
            char thisChar = (char)thisCode;
            if (thisCode == 13 || thisCode == 10) {
                this.randomfile.seek(this.position - 1L);
                byte nextCode = this.randomfile.readByte();
                if (thisCode == 10 && nextCode == 13 || thisCode == 13 && nextCode == 10) {
                    --this.position;
                }
                --this.position;
                break;
            }
            finalLine = thisChar + finalLine;
            --this.position;
        }
        return finalLine;
    }

    @Override
    public void close() throws IOException {
        if (this.randomfile != null) {
            this.randomfile.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

