/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.model;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.license.plugin.model.License;
import org.nuiton.plugin.PluginHelper;

public class LicenseRepository
implements Iterable<License> {
    private static final Log log = LogFactory.getLog(LicenseRepository.class);
    public static final String REPOSITORY_DEFINITION_FILE = "licenses.properties";
    protected URL baseURL;
    protected List<License> licenses;
    protected boolean init;

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.checkNotInit("setBaseURL");
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.checkNotInit("load");
        try {
            if (this.baseURL == null || this.baseURL.toString().trim().isEmpty()) {
                throw new IllegalStateException("no baseURL defined in " + this);
            }
            URL definitionURL = PluginHelper.getUrl((URL)this.getBaseURL(), (String)REPOSITORY_DEFINITION_FILE);
            if (this.licenses != null) {
                this.licenses.clear();
            } else {
                this.licenses = new ArrayList<License>();
            }
            if (!this.checkExists(definitionURL)) {
                throw new IllegalArgumentException("no licenses.properties found with url [" + definitionURL + "] for resolver " + this);
            }
            Properties p = new Properties();
            p.load(definitionURL.openStream());
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String licenseName = (String)entry.getKey();
                licenseName = licenseName.trim().toLowerCase();
                String licenseDescription = (String)entry.getValue();
                URL licenseURL = PluginHelper.getUrl((URL)this.baseURL, (String)licenseName);
                License license = new License();
                license.setName(licenseName);
                license.setDescription(licenseDescription);
                license.setBaseURL(licenseURL);
                if (log.isInfoEnabled()) {
                    log.info((Object)("register " + license.getDescription()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)license);
                }
                this.licenses.add(license);
            }
            this.licenses = Collections.unmodifiableList(this.licenses);
        }
        finally {
            this.init = true;
        }
    }

    public String[] getLicenseNames() {
        this.checkInit("getLicenseNames");
        ArrayList<String> result = new ArrayList<String>(this.licenses.size());
        for (License license : this) {
            result.add(license.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public License[] getLicenses() {
        this.checkInit("getLicenses");
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    public License getLicense(String licenseName) {
        this.checkInit("getLicense");
        if (licenseName == null || licenseName.trim().isEmpty()) {
            throw new IllegalArgumentException("licenceName can not be null, nor empty");
        }
        License license = null;
        for (License l : this) {
            if (!licenseName.equals(l.getName())) continue;
            license = l;
            break;
        }
        return license;
    }

    @Override
    public Iterator<License> iterator() {
        this.checkInit("iterator");
        return this.licenses.iterator();
    }

    protected boolean checkExists(URL url) throws IOException {
        URLConnection openConnection = url.openConnection();
        return openConnection.getContentLength() > 0;
    }

    protected void checkInit(String operation) throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("repository " + this + " was not init, operation [" + operation + "] not possible.");
        }
    }

    protected void checkNotInit(String operation) throws IllegalStateException {
        if (this.init) {
            throw new IllegalStateException("repository " + this + "was init, operation [" + operation + "+] not possible.");
        }
    }
}

