/*
 * *##% 
 * Maven License Plugin
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin.repository;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Model of a license definition in a license repository.
 *
 * @since 1.0.3
 */
public class LicenseDefinition {

    public static final String LICENSE_HEADER_FILE = "header.txt";
    public static final String LICENSE_CONTENT_FILE = "license.txt";
    protected URL baseURL;
    protected String name;
    protected String description;

    public LicenseDefinition(URL baseURL, String name, String description) {
        this.baseURL = baseURL;
        this.name = name;
        this.description = description;
    }

    public URL getBaseURL() {
        return baseURL;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public URL getLicenseURL() throws IOException {
        return LicenseRepository.getUrl(baseURL, LICENSE_CONTENT_FILE);
    }

    public URL getHeaderURL() throws IOException {
        return LicenseRepository.getUrl(baseURL, LICENSE_HEADER_FILE);
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("name", name);
        builder.append("description", description);
        builder.append("baseURL", baseURL);
        return builder.toString();
    }
}
