/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.mail.plugin;

import org.nuiton.mail.MailSender;
import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.nuiton.plugin.AbstractMojoTest;

/**
 * @author tchemit
 * @since 1.0.0
 */
public class SendEmailMojoTest extends AbstractMojoTest<SendEmailMojo> {

    protected boolean canContinue;

    @Override
    protected String getGoalName(String methodName) {
        return "send-email";
    }

    @Override
    protected void setUpMojo(SendEmailMojo mojo, File pomFile) throws Exception {
        super.setUpMojo(mojo, pomFile);

        // add a mailSender here
        MailSender sender = new MailSender();
        sender.setName("Nuiton Release Notification");
        sender.setEmail("test@noway.fr");
        mojo.setMailSender(sender);

        // add a destination
        mojo.setToAddresses(Arrays.asList("chemit@codelutin.com"));

        canContinue = mojo.init();
        if (canContinue) {
            if (mojo.isVerbose()) {
                log.info("setup done for " + mojo.getProject().getFile().getName());
            }
        } else {
            log.error("setup was not successfull, will skip this test [" + getClass() + "]");
        }
    }

    @Test
    public void sendEmail() throws Exception {
        Assume.assumeTrue(canContinue);

        Assert.assertNotNull(getMojo());
        getMojo().doAction();
    }

    @Test
    public void skipSendEmail() throws Exception {
        Assume.assumeTrue(canContinue);
        Assert.assertNotNull(getMojo());
        getMojo().doAction();
    }
}
