/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.io.rest;

import java.net.URL;

/**
 * Contract of a {@link RestClient}.
 * 
 * @author chemit
 * @since 1.0.3
 */
public interface RestClientConfiguration {

    URL getRestUrl();

    String getEncoding();

    String getRestUsername();

    String getRestPassword();

    boolean isVerbose();

    void setRestUrl(URL restUrl);

    void setRestPassword(String restPassword);

    void setRestUsername(String restUsername);

    void setEncoding(String encoding);

    void setVerbose(boolean verbose);
}
