/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license;

import org.junit.Test;

import java.io.File;
import java.util.Map;

/** @author chemit */
public class LicenseFactoryTest extends BaseLicenseTestCase {

    @Test
    public void testNewInstance() throws Exception {

        LicenseFactory factory = LicenseFactory.newInstance();
        assertNotNull(factory);
        assertEquals(1, factory.resolvers.size());
        assertNotNull(factory.resolvers.get(0));
        assertEquals(JarLicenseResolver.class, factory.resolvers.get(0).getClass());

        factory = LicenseFactory.newInstance("");
        assertNotNull(factory);
        assertEquals(1, factory.resolvers.size());
        assertNotNull(factory.resolvers.get(0));
        assertEquals(JarLicenseResolver.class, factory.resolvers.get(0).getClass());

        factory = LicenseFactory.newInstance("yo");
        assertNotNull(factory);

        assertEquals(2, factory.resolvers.size());
        assertNotNull(factory.resolvers.get(0));
        assertEquals(JarLicenseResolver.class, factory.resolvers.get(0).getClass());
        assertNotNull(factory.resolvers.get(1));
        assertEquals(LicenseResolver.class, factory.resolvers.get(1).getClass());
        assertEquals("yo", factory.resolvers.get(1).getBaseURL());

        factory.addResolver(new LicenseResolver("yo2"));
        assertEquals(3, factory.resolvers.size());
        assertNotNull(factory.resolvers.get(0));
        assertEquals(JarLicenseResolver.class, factory.resolvers.get(0).getClass());
        assertNotNull(factory.resolvers.get(1));
        assertEquals(LicenseResolver.class, factory.resolvers.get(1).getClass());
        assertEquals("yo", factory.resolvers.get(1).getBaseURL());
        assertEquals(LicenseResolver.class, factory.resolvers.get(2).getClass());
        assertEquals("yo2", factory.resolvers.get(2).getBaseURL());

    }

    @Test
    public void testGetLicenseNames() throws Exception {
        LicenseFactory factory = LicenseFactory.newInstance();

        int expectedJarResolverLicenses = 5;
        Map<String, String> licenseNames = factory.getLicenseNames();
        //todo make dynamic that test
        assertEquals(expectedJarResolverLicenses, licenseNames.size());

        // create a new dummy license repository with a license
        File repo = createLicenseRepository(true);

        LicenseResolver resolver = new LicenseResolver();
        resolver.setBaseURL(repo.toURI().toURL().toString());

        factory.addResolver(resolver);

        licenseNames = factory.getLicenseNames();
        assertEquals(expectedJarResolverLicenses + 1, licenseNames.size());

        // add a new license to repo
        long timestamp = System.currentTimeMillis();
        String licenseName = "dummy2_" + timestamp;
        addLicenseToRepository(repo, licenseName);

        factory = LicenseFactory.newInstance(repo.toURI().toURL().toString());

        licenseNames = factory.getLicenseNames();
        assertEquals(expectedJarResolverLicenses + 2, licenseNames.size());

    }

}
