/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license;

import org.junit.Assert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.codehaus.plexus.util.IOUtil;
import org.nuiton.util.PluginHelper;

/** @author chemit */
public abstract class BaseLicenseTestCase extends Assert {

    protected static final String encoding = "utf-8";

    protected File getBaseDir() {
        String path = System.getenv("basedir");
        if (path == null) {
            path = new File("").getAbsolutePath();
        }
        return new File(path);
    }

    protected void assertLicenseFound(String name, License license) throws IOException {
        assertNotNull(license);
        assertEquals(name, license.getName());
        assertNotNull(license.getLicenseContent(encoding));
        assertNotNull(license.getHeaderContent(encoding));
    }

    protected File createLicenseRepository(boolean createLicene) throws IOException {
        long timestamp = System.currentTimeMillis();

        File repo = new File(getBaseDir(), "target" + File.separator + "licenses_" + timestamp);

        if (createLicene) {

            String licenseName = "dummy_" + timestamp;
            addLicenseToRepository(repo, licenseName);
        }
        return repo;
    }

    protected void addLicenseToRepository(File repo, String licenseName) throws IOException {

        File defFile = new File(repo, "licenses.properties");

        String content = "";
        if (defFile.exists()) {

            content = IOUtil.toString(new FileInputStream(defFile), encoding) + "\n";
//            content = FileUtil.readAsString(defFile, encoding) + "\n";
        }


        PluginHelper.write(defFile, content + licenseName + "=My dummy license\n", encoding);
//        FileUtil.writeString(defFile, content + licenseName + "=My dummy license\n", encoding);
        // create dummy licenses
        File file = new File(repo, licenseName);
        file.mkdirs();
        PluginHelper.write(new File(file, "license.txt"), "license:" + licenseName, encoding);
        PluginHelper.write(new File(file, "header.txt"), "header:" + licenseName, encoding);
//        FileUtil.writeString(new File(file, "license.txt"), "license:" + licenseName, encoding);
//        FileUtil.writeString(new File(file, "header.txt"), "header:" + licenseName, encoding);

    }
}

