/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A factory of {@link LicenseGenerator}
 *
 * @author chemit
 * @deprecated since 1.0.0, no more use (LicenseGenerator is no more in this project...)
 */
@Deprecated
public class LicenseGeneratorFactory {

    public static class LicenceGeneratorContext {

        File src;
        String[] files;

        public LicenceGeneratorContext(File src, String[] files) {
            this.src = src;
            this.files = files;
        }

        public File getSrc() {
            return src;
        }

        public String[] getFiles() {
            return files;
        }

        public void setSrc(File src) {
            this.src = src;
        }

        public void setFiles(String[] files) {
            this.files = files;
        }
        
    }

    protected static Map<LicenseGenerator, List<String>> availableGenerator;

    public static Map<LicenseGenerator, List<String>> getAvailableGenerator() {
        if (availableGenerator == null) {
            availableGenerator = new HashMap<LicenseGenerator, List<String>>();
        }
        return availableGenerator;
    }

    public static List<String> getGeneratorMatchers(LicenseGenerator generator) {
        List<String> result = null;
        if (availableGenerator != null) {
            result = availableGenerator.get(generator);
            if (result == null) {
                // add a new empty list in cache
                result = new ArrayList<String>();
                availableGenerator.put(generator, result);
            }
        }
        return result;
    }

    public static void addGenerator(LicenseGenerator generator, String matcher) {
        List<String> matchers = getGeneratorMatchers(generator);
        if (matcher.isEmpty() || !matcher.contains(matcher)) {
            matchers.add(matcher);
        }
    }

}
