/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.List;
import org.nuiton.math.matrix.DoubleBigVector;
import org.nuiton.math.matrix.DoubleSparseArrayVector;
import org.nuiton.math.matrix.LazyVector;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.math.matrix.MatrixProvider;
import org.nuiton.math.matrix.MatrixProxy;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.math.matrix.Vector;

public class MatrixFactory {
    protected static boolean defaultUseLazyVector = true;
    protected static Class<?> defaultVectorClass = DoubleBigVector.class;
    protected static Class<?> defaultSparseVectorClass = DoubleSparseArrayVector.class;
    protected static int defaultThresholdSparse = 1000;
    protected Class<?> vectorClass = null;
    protected Class<?> sparseVectorClass = null;
    protected int thresholdSparse = 1000;
    protected boolean useLazyVector = true;
    protected static SemanticMapper defaultSemanticMapper = new SemanticMapper();
    private static ThreadLocal<MatrixFactory> matrixFactoryThreadLocal = new ThreadLocal();

    protected MatrixFactory(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        this.vectorClass = vectorClass;
        this.sparseVectorClass = sparseVectorClass;
        this.thresholdSparse = thresholdSparse;
        this.useLazyVector = useLazyVector;
    }

    public Class<?> getVectorClass() {
        return this.vectorClass;
    }

    public Class<?> getSparseVectorClass() {
        return this.sparseVectorClass;
    }

    public int getThresholdSparse() {
        return this.thresholdSparse;
    }

    public boolean isUseLazyVector() {
        return this.useLazyVector;
    }

    public static void setDefaultVectorClass(Class<?> vectorClass) {
        defaultVectorClass = vectorClass;
    }

    public static void setDefaultSparseVectorClass(Class<?> defaultSparseVectorClass) {
        MatrixFactory.defaultSparseVectorClass = defaultSparseVectorClass;
    }

    public static void setDefaultThresholdSparse(int defaultThresholdSparse) {
        MatrixFactory.defaultThresholdSparse = defaultThresholdSparse;
    }

    public static void setDefaultUseLazyVector(boolean useLazyVector) {
        defaultUseLazyVector = useLazyVector;
    }

    public static Class<?> getDefaultVectorClass() {
        return defaultVectorClass;
    }

    public static void setSemanticMapper(SemanticMapper semanticMapper) {
        defaultSemanticMapper = semanticMapper;
    }

    public static SemanticMapper getSemanticMapper() {
        return defaultSemanticMapper;
    }

    public static MatrixFactory getInstance(Class<?> vectorClass) {
        return new MatrixFactory(vectorClass, vectorClass, 0, defaultUseLazyVector);
    }

    public static MatrixFactory getInstance(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse) {
        return new MatrixFactory(vectorClass, sparseVectorClass, thresholdSparse, defaultUseLazyVector);
    }

    public static MatrixFactory getInstance(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        return new MatrixFactory(vectorClass, sparseVectorClass, thresholdSparse, useLazyVector);
    }

    public static MatrixFactory getInstance() {
        MatrixFactory result = matrixFactoryThreadLocal.get();
        if (result == null) {
            result = MatrixFactory.getInstance(defaultVectorClass, defaultSparseVectorClass, defaultThresholdSparse, defaultUseLazyVector);
        }
        return result;
    }

    public static void initMatrixFactoryThreadLocal(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        matrixFactoryThreadLocal.set(MatrixFactory.getInstance(vectorClass, sparseVectorClass, thresholdSparse, useLazyVector));
    }

    public static void removeMatrixFactoryThreadLocal() {
        matrixFactoryThreadLocal.remove();
    }

    public MatrixND create(int[] dim) {
        return new MatrixNDImpl(this, dim);
    }

    public MatrixND create(double[] values, int[] dim) {
        int i;
        if (dim.length > 2) {
            return null;
        }
        MatrixNDImpl matrix = new MatrixNDImpl(this, dim);
        if (dim.length == 2) {
            for (i = 0; i < dim[0]; ++i) {
                for (int j = 0; j < dim[1]; ++j) {
                    int[] coordinates = new int[]{i, j};
                    matrix.setValue(coordinates, values[i * dim[1] + j]);
                }
            }
        }
        if (dim.length == 1) {
            for (i = 0; i < dim[0]; ++i) {
                int[] coordinates = new int[]{i};
                matrix.setValue(coordinates, values[i]);
            }
        }
        return matrix;
    }

    public MatrixND create(List<?>[] semantics) {
        return new MatrixNDImpl(this, semantics);
    }

    public MatrixND create(String name, int[] dim) {
        return new MatrixNDImpl(this, name, dim);
    }

    public MatrixND create(String name, int[] dim, String[] dimNames) {
        return new MatrixNDImpl(this, name, dim, dimNames);
    }

    public MatrixND create(String name, int[] dim, String[] dimNames, Vector data) {
        return new MatrixNDImpl(this, name, dim, dimNames);
    }

    public MatrixND create(String name, List<?>[] semantics) {
        return new MatrixNDImpl(this, name, semantics);
    }

    public MatrixND create(String name, List<?>[] semantics, String[] dimNames) {
        return new MatrixNDImpl(this, name, semantics, dimNames);
    }

    public MatrixND create(String name, List<?>[] semantics, String[] dimNames, Vector data) {
        return new MatrixNDImpl(this, name, semantics, dimNames, data);
    }

    public MatrixND create(MatrixND matrix) {
        return new MatrixNDImpl(this, matrix);
    }

    public MatrixND create(MatrixND matrix, Vector data) {
        return new MatrixNDImpl(this, matrix, data);
    }

    public MatrixND matrixId(int size) {
        MatrixND result = this.create(new int[]{size, size});
        for (int i = 0; i < size; ++i) {
            result.setValue(i, i, 1.0);
        }
        return result;
    }

    protected Vector createVector(int length) {
        try {
            Vector result = this.thresholdSparse <= 0 || length <= this.thresholdSparse ? (Vector)this.vectorClass.newInstance() : (Vector)this.sparseVectorClass.newInstance();
            if (this.useLazyVector) {
                result = new LazyVector(result, length);
            }
            result.init(length);
            return result;
        }
        catch (Exception eee) {
            throw new RuntimeException("Can't create vector", eee);
        }
    }

    public MatrixProxy createProxy(List<?>[] semantics, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, semantics);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, int[] dim, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, dim);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, int[] dim, String[] dimNames, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, dim, dimNames);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, List<?>[] semantics, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, semantics);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, List<?>[] semantics, String[] dimNames, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, semantics, dimNames);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }
}

