/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.report;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.I18nAble;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

public class IssueReportGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ISSUE_TOKEN = "%ISSUE%";
    private static final String VERSION_TOKEN = "%VERSION%";
    private ReportColumn[] columns;
    private ReportColumn groupColumn;
    private String url;
    private String issueLinkTemplate;
    private String versionLinkTemplate;
    private Issue[] issues;
    private Map<Integer, IssueCategory> issueCategories;
    private Map<Integer, IssuePriority> issuePriorities;
    private Map<Integer, Version> versions;
    private Map<Integer, IssueStatus> issueStatuses;
    private Map<Integer, User> users;
    private Map<Integer, Tracker> trackers;
    private DateFormat dateFormat;

    public IssueReportGenerator() {
    }

    public IssueReportGenerator(Log log, String columnNames, String groupBy) throws MavenReportException {
        ArrayList<ReportColumn> tmp;
        block9: {
            String[] columnNamesArray = columnNames.split(",");
            int nbCols = columnNamesArray.length;
            tmp = new ArrayList<ReportColumn>(nbCols);
            for (String col : columnNames.split(",")) {
                try {
                    ReportColumn valueOf = ReportColumn.valueOf(col.trim().toLowerCase());
                    tmp.add(valueOf);
                }
                catch (Exception e) {
                    log.warn((CharSequence)(col + " is an unkown column name, authorized : " + Arrays.toString((Object[])ReportColumn.values())));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Throwable)e);
                }
            }
            if (tmp.isEmpty()) {
                throw new MavenReportException("maven-redmine-plugin: None of the configured columnNames '" + columnNames + "' are valid.");
            }
            if (groupBy != null && !groupBy.trim().isEmpty()) {
                try {
                    this.groupColumn = ReportColumn.valueOf(groupBy.trim().toLowerCase());
                    if (!this.groupColumn.isCanGroup()) {
                        log.warn((CharSequence)((Object)((Object)this.groupColumn) + " is not a grouping columne, grouping will be skip."));
                        this.groupColumn = null;
                    } else {
                        tmp.remove((Object)this.groupColumn);
                    }
                    log.info((CharSequence)("group by " + (Object)((Object)this.groupColumn)));
                }
                catch (Exception e) {
                    log.warn((CharSequence)(groupBy + " is an unkown group column name, grouping will be skip."));
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Throwable)e);
                }
            }
        }
        this.columns = tmp.toArray(new ReportColumn[tmp.size()]);
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        sink.text(bundle.getString("report.empty"));
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink, Log log) throws MojoExecutionException {
        if (this.issues != null && this.issues.length == 0) {
            throw new MojoExecutionException("maven-redmine-plugin: Can not generate report if no issues, use the doGenerateEmptyReport instead");
        }
        String d = bundle.getString("report.date.format");
        this.dateFormat = new SimpleDateFormat(d);
        this.sinkBeginReport(sink, bundle);
        if (this.groupColumn == null) {
            sink.table();
            this.constructHeaderRow(sink, bundle);
            this.constructDetailRows(sink, this.issues);
            sink.table_();
        } else {
            TreeMap<Integer, List<Issue>> groups = new TreeMap<Integer, List<Issue>>();
            this.groupColumn.collectGroups(this.issues, groups);
            for (Map.Entry e : groups.entrySet()) {
                List currentIssues = (List)e.getValue();
                sink.sectionTitle2();
                this.sinkRawText(sink, bundle.getString(this.groupColumn.getI18nKey()) + " : ");
                this.groupColumn.sinkInsideCell(sink, this, (Issue)currentIssues.get(0));
                sink.sectionTitle2_();
                sink.table();
                this.constructHeaderRow(sink, bundle);
                this.constructDetailRows(sink, currentIssues.toArray(new Issue[currentIssues.size()]));
                sink.table_();
            }
        }
        this.sinkEndReport(sink);
    }

    public boolean canGenerateIssueLinks() {
        return !StringUtils.isEmpty((String)this.issueLinkTemplate) && (!StringUtils.isBlank((String)this.getUrl()) || this.issueLinkTemplate.indexOf(URL_TOKEN) < 0);
    }

    public boolean canGenerateVersionLinks() {
        return !StringUtils.isEmpty((String)this.versionLinkTemplate) && (!StringUtils.isBlank((String)this.getUrl()) || this.versionLinkTemplate.indexOf(URL_TOKEN) < 0);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setIssueLinkTemplate(String issueLinkTemplate) {
        this.issueLinkTemplate = issueLinkTemplate;
    }

    public void setVersionLinkTemplate(String versionLinkTemplate) {
        this.versionLinkTemplate = versionLinkTemplate;
    }

    public void setIssueCategories(IssueCategory[] issueCategories) {
        TreeMap<Integer, IssueCategory> t = new TreeMap<Integer, IssueCategory>();
        for (IssueCategory s : issueCategories) {
            t.put(s.getId(), s);
        }
        this.issueCategories = t;
    }

    public void setIssueStatuses(IssueStatus[] issueStatuses) {
        TreeMap<Integer, IssueStatus> t = new TreeMap<Integer, IssueStatus>();
        for (IssueStatus s : issueStatuses) {
            t.put(s.getId(), s);
        }
        this.issueStatuses = t;
    }

    public void setIssuePriorities(IssuePriority[] issuePriorities) {
        TreeMap<Integer, IssuePriority> t = new TreeMap<Integer, IssuePriority>();
        for (IssuePriority s : issuePriorities) {
            t.put(s.getId(), s);
        }
        this.issuePriorities = t;
    }

    public void setUsers(User[] users) {
        TreeMap<Integer, User> t = new TreeMap<Integer, User>();
        for (User s : users) {
            t.put(s.getId(), s);
        }
        this.users = t;
    }

    public void setVersions(Version[] users) {
        TreeMap<Integer, Version> t = new TreeMap<Integer, Version>();
        for (Version s : users) {
            t.put(s.getId(), s);
        }
        this.versions = t;
    }

    public void setTrackers(Tracker[] users) {
        TreeMap<Integer, Tracker> t = new TreeMap<Integer, Tracker>();
        for (Tracker s : users) {
            t.put(s.getId(), s);
        }
        this.trackers = t;
    }

    public void setIssues(Issue[] issues) {
        this.issues = issues;
    }

    protected void constructHeaderRow(Sink sink, ResourceBundle bundle) {
        sink.tableRow();
        for (ReportColumn c : this.columns) {
            this.sinkHeader(sink, bundle.getString(c.getI18nKey()));
        }
        sink.tableRow_();
    }

    protected void constructDetailRows(Sink sink, Issue[] issues) {
        for (Issue issue : issues) {
            sink.tableRow();
            for (ReportColumn col : this.columns) {
                sink.tableCell();
                col.sinkInsideCell(sink, this, issue);
                sink.tableCell_();
            }
            sink.tableRow_();
        }
    }

    protected String parseIssueLink(String issue) {
        String issueLink = this.issueLinkTemplate;
        String parseLink = issueLink.replaceFirst(ISSUE_TOKEN, issue);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            parseLink = parseLink.replaceFirst(URL_TOKEN, this.url);
        }
        return parseLink;
    }

    protected String parseVersionLink(String issue) {
        String issueLink = this.versionLinkTemplate;
        String parseLink = issueLink.replaceFirst(VERSION_TOKEN, issue);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            parseLink = parseLink.replaceFirst(URL_TOKEN, this.url);
        }
        return parseLink;
    }

    protected void constructIssueLink(Issue issue, Sink sink) {
        String id = issue.getId() + "";
        if (StringUtils.isNotEmpty((String)id)) {
            sink.link(this.parseIssueLink(id));
            sink.text(issue.getSubject());
            sink.link_();
        }
    }

    protected void constructVersionLink(Version v, Sink sink, String prefix) {
        String id = v.getId() + "";
        if (StringUtils.isNotEmpty((String)id)) {
            sink.link(this.parseVersionLink(id));
            sink.text(prefix + " " + v.getName());
            sink.link_();
        }
    }

    protected boolean isGroup() {
        return this.groupColumn != null;
    }

    protected IssueStatus getIssueStatus(int id) {
        return this.issueStatuses == null ? null : this.issueStatuses.get(id);
    }

    protected IssueCategory getIssueCategory(int id) {
        return this.issueCategories == null ? null : this.issueCategories.get(id);
    }

    protected IssuePriority getIssuePriority(int id) {
        return this.issuePriorities == null ? null : this.issuePriorities.get(id);
    }

    protected Version getVersion(int id) {
        return this.versions == null ? null : this.versions.get(id);
    }

    protected User getUser(int id) {
        return this.users == null ? null : this.users.get(id);
    }

    protected Tracker getTracker(int id) {
        return this.trackers == null ? null : this.trackers.get(id);
    }

    protected void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        String title = this.isGroup() ? bundle.getString("report.header-" + this.groupColumn.name()) : bundle.getString("report.header");
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        this.sinkSectionTitle1(sink, title);
    }

    protected void sinkEndReport(Sink sink) {
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    protected void sinkRawText(Sink sink, String text) {
        if (text != null) {
            sink.rawText(text);
        } else {
            sink.rawText("&nbsp;");
        }
    }

    protected void sinkDate(Sink sink, Date d) {
        String text = d == null ? " - " : this.dateFormat.format(d);
        this.sinkRawText(sink, text);
    }

    protected void sinkI18nAble(Sink sink, int id, I18nAble obj) {
        String t;
        if (obj == null) {
            t = id == 0 ? " - " : id + "";
        } else {
            t = obj.getName();
            if (obj instanceof Version) {
                this.constructVersionLink((Version)obj, sink, "");
                return;
            }
        }
        this.sinkRawText(sink, t);
    }

    protected void sinkSectionTitle1(Sink sink, String text) {
        sink.sectionTitle1();
        sink.text(text);
        sink.sectionTitle1_();
    }

    public static enum ReportColumn {
        key(false, "report.label.key"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                generator.constructIssueLink(issue, sink);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                throw new UnsupportedOperationException(this.name() + "does not supports grouping");
            }
        }
        ,
        summary(false, "report.label.summary"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                generator.sinkRawText(sink, issue.getDescription());
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                throw new UnsupportedOperationException(this.name() + "does not supports grouping");
            }
        }
        ,
        status(true, "report.label.status"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getStatusId();
                String t = id + "";
                IssueStatus status = generator.getIssueStatus(id);
                t = status == null ? (id == 0 ? "-" : t) : status.getName();
                generator.sinkI18nAble(sink, id, (I18nAble)status);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getStatusId();
            }
        }
        ,
        assignee(true, "report.label.by"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getAssignedToId();
                User u = generator.getUser(id);
                String t = issue.getAssignedToId() + "";
                if (u == null) {
                    generator.sinkRawText(sink, id == 0 ? " - " : t);
                } else {
                    sink.link("mailto:" + u.getMail());
                    sink.text(u.getLogin());
                    sink.link_();
                }
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getAssignedToId();
            }
        }
        ,
        reporter(true, "report.label.reporter"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getAuthorId();
                User u = generator.getUser(id);
                String t = issue.getAuthorId() + "";
                if (u == null) {
                    generator.sinkRawText(sink, id == 0 ? " - " : t);
                } else {
                    sink.link("mailto:" + u.getMail());
                    sink.text(u.getLogin());
                    sink.link_();
                }
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getAuthorId();
            }
        }
        ,
        tracker(true, "report.label.type"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getTrackerId();
                Tracker status = generator.getTracker(id);
                generator.sinkI18nAble(sink, id, (I18nAble)status);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getTrackerId();
            }
        }
        ,
        priority(true, "report.label.priority"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getPriorityId();
                IssuePriority p = generator.getIssuePriority(id);
                generator.sinkI18nAble(sink, id, (I18nAble)p);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getPriorityId();
            }
        }
        ,
        version(true, "report.label.version"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getFixedVersionId();
                Version v2 = generator.getVersion(id);
                generator.sinkI18nAble(sink, id, (I18nAble)v2);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getFixedVersionId();
            }
        }
        ,
        category(true, "report.label.category"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                int id = issue.getCategoryId();
                IssueCategory status = generator.getIssueCategory(id);
                generator.sinkI18nAble(sink, id, (I18nAble)status);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                return issue.getCategoryId();
            }
        }
        ,
        createdon(false, "report.label.created"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                Date d = issue.getCreatedOn();
                generator.sinkDate(sink, d);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                throw new UnsupportedOperationException(this.name() + "does not supports grouping");
            }
        }
        ,
        updatedon(false, "report.label.updated"){

            @Override
            public void sinkInsideCell(Sink sink, IssueReportGenerator generator, Issue issue) {
                Date d = issue.getUpdatedOn();
                generator.sinkDate(sink, d);
            }

            @Override
            protected Integer getGroupId(Issue issue) {
                throw new UnsupportedOperationException(this.name() + "does not supports grouping");
            }
        };

        private boolean canGroup;
        private String i18nKey;

        private ReportColumn(boolean canGroup, String i18nKey) {
            this.canGroup = canGroup;
            this.i18nKey = i18nKey;
        }

        public boolean isCanGroup() {
            return this.canGroup;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public abstract void sinkInsideCell(Sink var1, IssueReportGenerator var2, Issue var3);

        protected abstract Integer getGroupId(Issue var1);

        public void collectGroups(Issue[] issues, Map<Integer, List<Issue>> groups) {
            for (Issue issue : issues) {
                Integer id = this.getGroupId(issue);
                List<Issue> c = groups.get(id);
                if (c == null) {
                    c = new ArrayList<Issue>();
                    groups.put(id, c);
                }
                c.add(issue);
            }
        }
    }
}

