package org.nuiton.jaxx.widgets.status;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class MemoryStatusWidget extends JComponent implements ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Tu24TQRS9XmKHOOGRFEgUSEYOBAmYJbURr0QWRA6RMBIRbhh7h/Wa9cwwM4s3TQoKOn6AgpYG5R8iKiQaWv8DUj6BO2PHa9A6PLbYx+yZM+eee+7nH1DUCm4IFRKeREZw0qNpSlTCTdRnZOv+7u5Ou8c6ZpPpjoqkEQpGV8EDrwWLwWRdGyCtBjL5IybfMvljJn9D9KXgjE8R1RpQ1mYvZrrLmDFwbebmjtZ+c4KspTJR47NyVeed9e3d+rDANj94AKlE+XNY9vV/IMiqnmuAFwUGVho9+ob6MeUhilMRD7GgM3ZtI6ZaP6Z99hr2Yb4BJUkVkhm4+V/2ODpHlUoDS6tbE/AtA+u/1zCIgpAZTbShJtFkm/WF2mu6j2ful5SOrGSgaI9WBpat6JToAdZAntq1DLMilQgV0/oB7bwKlUg4ln7WbiB0YNCpWOSh60KxEdr+WUaEgquz7Mb2kqy9mdOFFhRVgssGqrOTZcPxBFGjWFRnx8Ie44BvD/bVp8HR8DgLHoqr/GnXVOyxMVinROsiq+3cKAiJiWJ/m8paCxY0i3Fm3Eysnay8OUaielThOkEsE3lIdRfZivPDwy8XXnw/BV4dyrGgQZ1a/CNYMF10uiviIJV37zlxS4PTeD9vZRoot6c7djughlbaEQ+wyXdSdGrtZKcmwg52jr5+fH/l8NitAupc/ZudmWPF51CKeBxx5mZnPBa5s7IoNUsCkWU+bwoK9lmW49xddPdLuR68/CWHlTSxj8uuCvtWnTD9BJ9QmhcKBQAA";
    private static final Log log = LogFactory.getLog(MemoryStatusWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected MemoryStatusWidgetHandler handler;
    protected Color progressBackground;
    protected Color progressForeground;
    protected Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MemoryStatusWidget $JComponent0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        handler.paintComponent(g);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidgetHandler getHandler() {
        return handler;
    }

    public Color getProgressBackground() {
        return progressBackground;
    }

    public Color getProgressForeground() {
        return progressForeground;
    }

    public Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProgressBackground(Color progressBackground) {
        Color oldValue = this.progressBackground;
        this.progressBackground = progressBackground;
        firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, progressBackground);
    }

    public void setProgressForeground(Color progressForeground) {
        Color oldValue = this.progressForeground;
        this.progressForeground = progressForeground;
        firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, progressForeground);
    }

    public void setTimer(Timer timer) {
        Timer oldValue = this.timer;
        this.timer = timer;
        firePropertyChange(PROPERTY_TIMER, oldValue, timer);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createProgressBackground() {
        $objectMap.put("progressBackground", progressBackground = Color.decode("#666699a"));
    }

    protected void createProgressForeground() {
        $objectMap.put("progressForeground", progressForeground = Color.decode("#cccccc"));
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JComponent0 = this;
        handler = new MemoryStatusWidgetHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JComponent0", $JComponent0);
        createTimer();
        createProgressBackground();
        createProgressForeground();
        // inline creation of $JComponent0
        setName("$JComponent0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}